/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.economy.commands.plots;

import com.forgeessentials.api.APIRegistry;
import com.forgeessentials.api.permissions.AreaZone;
import com.forgeessentials.core.commands.ForgeEssentialsCommandBase;
import com.forgeessentials.economy.ModuleEconomy;
import com.forgeessentials.economy.Offer;
import com.forgeessentials.economy.plots.PlotManager;
import com.forgeessentials.economy.plots.TransactionHandler;
import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.util.UserIdent;
import com.forgeessentials.util.questioner.QuestionData;
import com.forgeessentials.util.questioner.Questioner;
import java.util.UUID;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.permissions.PermissionsManager;

public class CommandBuyPlot
extends ForgeEssentialsCommandBase {
    @Override
    public void processCommandPlayer(EntityPlayerMP buyer, String[] args) {
        if (args.length >= 1) {
            int value;
            AreaZone plot = (AreaZone)APIRegistry.perms.getZoneById("[PLOT]" + args[0]);
            if (!plot.checkGroupPermission("_ALL_", "fe.economy.plots").booleanValue()) {
                throw new CommandException("No such plot!", new Object[0]);
            }
            EntityPlayerMP seller = UserIdent.getPlayerByUuid(UUID.fromString(plot.getGroupPermission("_ALL_", "fe.economy.plots.data.owner")));
            if (args[1] != null) {
                value = Integer.parseInt(args[1]);
            } else {
                value = Integer.parseInt(plot.getGroupPermission("_ALL_", "fe.economy.plots.data.value"));
                OutputHandler.chatNotification((ICommandSender)buyer, "No value specified. Will use current valuation of plot, which is " + ModuleEconomy.formatCurrency(value));
            }
            if (APIRegistry.wallet.getWallet(new UserIdent(buyer).getUuid()) >= value) {
                throw new CommandException("You can't afford that!", new Object[0]);
            }
            Offer<AreaZone> item = new Offer<AreaZone>((EntityPlayer)buyer, (EntityPlayer)seller, plot, value);
            Questioner.addToQuestionQueue(new QuestionData((ICommandSender)seller, "Player " + buyer.getDisplayName() + " offered to purchase plot " + plot.getName() + " for " + ModuleEconomy.formatCurrency(value) + ". Type /yes to accept, /no to deny. This offer will expire in " + PlotManager.timeout + " seconds.", new TransactionHandler(item), PlotManager.timeout));
            PlotManager.pendingOffers.put(plot.getName(), item);
        } else {
            OutputHandler.chatError((ICommandSender)buyer, "Incorrect syntax. Try this instead: <plotName> <amount>");
        }
    }

    @Override
    public boolean canConsoleUseCommand() {
        return false;
    }

    @Override
    public String getPermissionNode() {
        return "fe.economy.plots.buy";
    }

    @Override
    public PermissionsManager.RegisteredPermValue getDefaultPermission() {
        return PermissionsManager.RegisteredPermValue.TRUE;
    }

    public String func_71517_b() {
        return "buyplot";
    }

    public String func_71518_a(ICommandSender p_71518_1_) {
        return "/buyplot <plotName> <amount> Offer to buy a plot. The owner of the plot is required to approve the transaction.";
    }
}

