/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.economy.commands;

import com.forgeessentials.api.APIRegistry;
import com.forgeessentials.core.commands.ForgeEssentialsCommandBase;
import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.util.UserIdent;
import cpw.mods.fml.common.registry.GameData;
import java.util.Arrays;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.permissions.PermissionsManager;

public class CommandSellCommand
extends ForgeEssentialsCommandBase {
    public String func_71517_b() {
        return "sellcommand";
    }

    public List<String> func_71514_a() {
        return Arrays.asList("sc", "scmd");
    }

    @Override
    public void processCommandConsole(ICommandSender sender, String[] args) {
        if (args.length >= 4) {
            String playerName = args[0];
            EntityPlayerMP player = UserIdent.getPlayerByMatchOrUsername(sender, playerName);
            if (player != null) {
                boolean found = false;
                boolean hasMeta = false;
                String itemName = args[1];
                int amount = Integer.parseInt(args[2]);
                int meta = -1;
                if (args.length >= 5) {
                    hasMeta = true;
                    meta = Integer.parseInt(args[3]);
                }
                Item offeredItem = null;
                try {
                    offeredItem = CommandBase.func_147179_f((ICommandSender)sender, (String)itemName);
                }
                catch (NumberFormatException e) {
                    offeredItem = (Item)GameData.getItemRegistry().func_82594_a(itemName);
                }
                if (offeredItem != null) {
                    ItemStack target = new ItemStack(offeredItem, amount, meta);
                    String targetName = target.func_77977_a();
                    for (int slot = 0; slot < player.field_71071_by.field_70462_a.length; ++slot) {
                        ItemStack is = player.field_71071_by.field_70462_a[slot];
                        if (is == null || !is.func_77977_a().equalsIgnoreCase(targetName) || meta != -1 && meta != is.func_77960_j() || is.field_77994_a < amount) continue;
                        player.field_71071_by.func_70298_a(slot, amount);
                        found = true;
                        break;
                    }
                    if (found) {
                        StringBuilder cmd = new StringBuilder(args.toString().length());
                        if (hasMeta) {
                            for (int i = 4; i < args.length; ++i) {
                                cmd.append(args[i]);
                                cmd.append(" ");
                            }
                        } else {
                            for (int i = 3; i < args.length; ++i) {
                                cmd.append(args[i]);
                                cmd.append(" ");
                            }
                        }
                        MinecraftServer.func_71276_C().func_71187_D().func_71556_a(sender, cmd.toString());
                        OutputHandler.chatConfirmation((ICommandSender)player, String.format("That cost you %d x %s. Your balance is %s.", amount, target.func_82833_r(), APIRegistry.wallet.getMoneyString(player.getPersistentID())));
                    } else {
                        OutputHandler.chatError((ICommandSender)player, "You don't have the requested item in your inventory!");
                    }
                } else {
                    OutputHandler.chatError(sender, String.format("Item %s was not found.", itemName));
                }
            } else {
                OutputHandler.chatError(sender, String.format("Player %s does not exist, or is not online.", args[0]));
            }
        } else {
            OutputHandler.chatError(sender, "Improper syntax. Please try this instead: <player> <['amount'x]item[:'meta']> <command [args]>");
        }
    }

    @Override
    public boolean canConsoleUseCommand() {
        return true;
    }

    @Override
    public String getPermissionNode() {
        return null;
    }

    @Override
    public boolean canPlayerUseCommand(EntityPlayer player) {
        return false;
    }

    public String func_71518_a(ICommandSender sender) {
        return "/sellcommand <player> <['amount'x]item[:'meta']> <command [args]>";
    }

    @Override
    public PermissionsManager.RegisteredPermValue getDefaultPermission() {
        return null;
    }
}

