/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.economy.commands;

import com.forgeessentials.api.APIRegistry;
import com.forgeessentials.core.commands.ForgeEssentialsCommandBase;
import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.util.UserIdent;
import cpw.mods.fml.common.FMLCommonHandler;
import java.util.Arrays;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.permissions.PermissionsManager;

public class CommandRemoveWallet
extends ForgeEssentialsCommandBase {
    public String func_71517_b() {
        return "removewallet";
    }

    public List<String> func_71514_a() {
        return Arrays.asList("walletremove");
    }

    @Override
    public void processCommandPlayer(EntityPlayerMP sender, String[] args) {
        if (args.length == 2) {
            EntityPlayerMP player = UserIdent.getPlayerByMatchOrUsername((ICommandSender)sender, args[0]);
            int amountToSubtract = Integer.parseInt(args[1]);
            if (player == null) {
                OutputHandler.chatError((ICommandSender)sender, "Player does not exist, or is not online.");
            } else {
                APIRegistry.wallet.removeFromWallet(amountToSubtract, player.getPersistentID());
                if (sender != player) {
                    OutputHandler.chatConfirmation((ICommandSender)sender, amountToSubtract + " " + APIRegistry.wallet.currency(amountToSubtract) + " was removed from the wallet.");
                }
                OutputHandler.chatNotification((ICommandSender)player, amountToSubtract + " " + APIRegistry.wallet.currency(amountToSubtract) + " was removed from your wallet.");
            }
        } else {
            OutputHandler.chatError((ICommandSender)sender, "Improper syntax. Please try this instead: <player> <amounttoremove>");
        }
    }

    @Override
    public void processCommandConsole(ICommandSender sender, String[] args) {
        if (args.length == 2) {
            EntityPlayerMP player = UserIdent.getPlayerByMatchOrUsername(sender, args[0]);
            int amountToSubtract = Integer.parseInt(args[1]);
            if (player == null) {
                OutputHandler.chatError(sender, "Player does not exist, or is not online.");
            } else {
                APIRegistry.wallet.removeFromWallet(amountToSubtract, player.getPersistentID());
                OutputHandler.chatConfirmation(sender, amountToSubtract + " " + APIRegistry.wallet.currency(amountToSubtract) + " was removed from the wallet.");
                OutputHandler.chatNotification((ICommandSender)player, amountToSubtract + " " + APIRegistry.wallet.currency(amountToSubtract) + " was removed from your wallet.");
            }
        } else {
            OutputHandler.chatError(sender, "Improper syntax. Please try this instead: <player> <amounttoremove>");
        }
    }

    @Override
    public boolean canConsoleUseCommand() {
        return true;
    }

    @Override
    public String getPermissionNode() {
        return "fe.economy." + this.func_71517_b();
    }

    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            return CommandRemoveWallet.func_71530_a((String[])args, (String[])FMLCommonHandler.instance().getMinecraftServerInstance().func_71213_z());
        }
        return null;
    }

    public String func_71518_a(ICommandSender sender) {
        return "/removewallet <player> <amounttoremove> Remove an amount of money from a player's wallet.";
    }

    @Override
    public PermissionsManager.RegisteredPermValue getDefaultPermission() {
        return PermissionsManager.RegisteredPermValue.OP;
    }
}

