/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.economy.commands;

import com.forgeessentials.api.APIRegistry;
import com.forgeessentials.core.commands.ForgeEssentialsCommandBase;
import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.util.UserIdent;
import cpw.mods.fml.common.FMLCommonHandler;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerSelector;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.permissions.PermissionsManager;

public class CommandPay
extends ForgeEssentialsCommandBase {
    public String func_71517_b() {
        return "pay";
    }

    @Override
    public void processCommandPlayer(EntityPlayerMP sender, String[] args) {
        if (args.length == 2) {
            EntityPlayerMP player = UserIdent.getPlayerByMatchOrUsername((ICommandSender)sender, args[0]);
            if (player == null) {
                OutputHandler.chatError((ICommandSender)sender, args[0] + " not found!");
            } else if (player == sender) {
                OutputHandler.chatError((ICommandSender)sender, "You can't pay yourself!");
            } else {
                int amount = CommandPay.func_71528_a((ICommandSender)sender, (String)args[1], (int)0);
                if (APIRegistry.wallet.getWallet(sender.getPersistentID()) >= amount) {
                    APIRegistry.wallet.removeFromWallet(amount, sender.getPersistentID());
                    APIRegistry.wallet.addToWallet(amount, player.getPersistentID());
                    OutputHandler.chatConfirmation((ICommandSender)sender, "You have payed " + player.func_70005_c_() + " " + amount + " " + APIRegistry.wallet.currency(amount));
                    OutputHandler.chatConfirmation((ICommandSender)player, "You have been payed " + amount + " " + APIRegistry.wallet.currency(amount) + " by " + sender.func_70005_c_());
                } else {
                    OutputHandler.chatError((ICommandSender)sender, "You can't afford that!!");
                }
            }
        } else {
            OutputHandler.chatError((ICommandSender)sender, "Improper syntax. Please try this instead: <player> <amount>");
        }
    }

    @Override
    public void processCommandConsole(ICommandSender sender, String[] args) {
        if (args.length == 2) {
            EntityPlayerMP player = UserIdent.getPlayerByMatchOrUsername(sender, args[0]);
            if (PlayerSelector.func_82378_b((String)args[0])) {
                player = UserIdent.getPlayerByMatchOrUsername(sender, args[0]);
            }
            if (player == null) {
                OutputHandler.chatError(sender, args[0] + " not found!");
            } else {
                int amount = CommandPay.func_71528_a((ICommandSender)sender, (String)args[1], (int)0);
                APIRegistry.wallet.addToWallet(amount, player.getPersistentID());
                OutputHandler.chatConfirmation(sender, "You have payed " + player.func_70005_c_() + " " + amount + " " + APIRegistry.wallet.currency(amount));
                OutputHandler.chatConfirmation((ICommandSender)player, "You have been payed " + amount + " " + APIRegistry.wallet.currency(amount) + " by " + sender.func_70005_c_());
            }
        } else {
            OutputHandler.chatError(sender, "Improper syntax. Please try this instead: <player> <amount>");
        }
    }

    @Override
    public boolean canConsoleUseCommand() {
        return true;
    }

    @Override
    public String getPermissionNode() {
        return "fe.economy." + this.func_71517_b();
    }

    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            return CommandPay.func_71530_a((String[])args, (String[])FMLCommonHandler.instance().getMinecraftServerInstance().func_71213_z());
        }
        return null;
    }

    public String func_71518_a(ICommandSender sender) {
        return "/pay <player> <amount> Pay another player an amount of money";
    }

    @Override
    public PermissionsManager.RegisteredPermValue getDefaultPermission() {
        return PermissionsManager.RegisteredPermValue.TRUE;
    }
}

