/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.economy.commands;

import com.forgeessentials.api.APIRegistry;
import com.forgeessentials.core.commands.ForgeEssentialsCommandBase;
import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.util.UserIdent;
import cpw.mods.fml.common.FMLCommonHandler;
import java.util.Arrays;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.permissions.PermissionsManager;

public class CommandAddToWallet
extends ForgeEssentialsCommandBase {
    public String func_71517_b() {
        return "addtowallet";
    }

    public List<String> func_71514_a() {
        return Arrays.asList("walletadd");
    }

    @Override
    public void func_71515_b(ICommandSender sender, String[] args) {
        if (args.length == 2) {
            EntityPlayerMP player = UserIdent.getPlayerByMatchOrUsername(sender, args[0]);
            int amountToAdd = Integer.parseInt(args[1]);
            if (player == null) {
                OutputHandler.chatError(sender, "Player %s does not exist, or is not online.");
            } else {
                APIRegistry.wallet.addToWallet(amountToAdd, player.getPersistentID());
                OutputHandler.chatConfirmation(sender, amountToAdd + " " + APIRegistry.wallet.currency(amountToAdd) + " added to wallet.");
                OutputHandler.chatConfirmation((ICommandSender)player, amountToAdd + " " + APIRegistry.wallet.currency(amountToAdd) + " added to your wallet.");
            }
        } else {
            OutputHandler.chatError(sender, "Improper syntax. Please try this instead: <player> <amounttoadd>");
        }
    }

    @Override
    public boolean canConsoleUseCommand() {
        return true;
    }

    @Override
    public String getPermissionNode() {
        return "fe.economy." + this.func_71517_b();
    }

    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            return CommandAddToWallet.func_71530_a((String[])args, (String[])FMLCommonHandler.instance().getMinecraftServerInstance().func_71213_z());
        }
        return null;
    }

    public String func_71518_a(ICommandSender sender) {
        return "/walletadd <player> <amounttoadd> Add an amount to a wallet.";
    }

    @Override
    public PermissionsManager.RegisteredPermValue getDefaultPermission() {
        return PermissionsManager.RegisteredPermValue.OP;
    }
}

