/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.economy;

import com.forgeessentials.api.IEconManager;
import com.forgeessentials.data.v2.DataManager;
import com.forgeessentials.economy.ModuleEconomy;
import com.forgeessentials.economy.Wallet;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;

public class WalletHandler
implements IEconManager {
    private static HashMap<UUID, Wallet> wallets = new HashMap();

    @Override
    public void addToWallet(int amountToAdd, UUID player) {
        WalletHandler.wallets.get((Object)player).amount += amountToAdd;
    }

    @Override
    public int getWallet(UUID player) {
        return WalletHandler.wallets.get((Object)player).amount;
    }

    @Override
    public boolean removeFromWallet(int amountToSubtract, UUID player) {
        if (WalletHandler.wallets.get((Object)player).amount - amountToSubtract >= 0) {
            WalletHandler.wallets.get((Object)player).amount -= amountToSubtract;
            return true;
        }
        return false;
    }

    @Override
    public void setWallet(int setAmount, EntityPlayer player) {
        WalletHandler.wallets.get((Object)player.func_110124_au()).amount = setAmount;
    }

    @Override
    public String currency(int amount) {
        if (amount == 1) {
            return ModuleEconomy.currencySingular;
        }
        return ModuleEconomy.currencyPlural;
    }

    @Override
    public String getMoneyString(UUID username) {
        int am = this.getWallet(username);
        return ModuleEconomy.formatCurrency(am);
    }

    private void saveWallet(Wallet wallet) {
        DataManager.getInstance().save(wallet, wallet.getUsername());
    }

    @Override
    public void save() {
        for (Wallet wallet : wallets.values()) {
            this.saveWallet(wallet);
        }
    }

    @Override
    public Map<String, Integer> getItemTables() {
        return ModuleEconomy.tables.valueMap;
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Wallet wallet = DataManager.getInstance().load(Wallet.class, event.player.func_110124_au().toString());
        if (wallet == null) {
            wallet = new Wallet(event.player, ModuleEconomy.startbudget);
        }
        wallets.put(event.player.func_110124_au(), wallet);
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        if (wallets.containsKey(event.player.func_110124_au())) {
            Wallet wallet = wallets.remove(event.player.func_110124_au());
            this.saveWallet(wallet);
        }
    }
}

