/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.data.v2.types;

import com.forgeessentials.data.v2.DataManager;
import com.forgeessentials.util.OutputHandler;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public class NBTTagCompoundType
implements DataManager.DataType<NBTTagCompound> {
    public JsonElement serialize(NBTTagCompound src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject result = new JsonObject();
        block19: for (String tagName : src.func_150296_c()) {
            NBTBase tag = src.func_74781_a(tagName);
            NBTBase.NBTPrimitive tagPrimitive = tag instanceof NBTBase.NBTPrimitive ? (NBTBase.NBTPrimitive)tag : null;
            switch (tag.func_74732_a()) {
                case 1: {
                    result.add("b:" + tagName, (JsonElement)new JsonPrimitive((Number)tagPrimitive.func_150290_f()));
                    continue block19;
                }
                case 2: {
                    result.add("s:" + tagName, (JsonElement)new JsonPrimitive((Number)tagPrimitive.func_150289_e()));
                    continue block19;
                }
                case 3: {
                    result.add("i:" + tagName, (JsonElement)new JsonPrimitive((Number)tagPrimitive.func_150287_d()));
                    continue block19;
                }
                case 4: {
                    result.add("l:" + tagName, (JsonElement)new JsonPrimitive((Number)tagPrimitive.func_150291_c()));
                    continue block19;
                }
                case 5: {
                    result.add("f:" + tagName, (JsonElement)new JsonPrimitive((Number)Float.valueOf(tagPrimitive.func_150288_h())));
                    continue block19;
                }
                case 6: {
                    result.add("d:" + tagName, (JsonElement)new JsonPrimitive((Number)tagPrimitive.func_150286_g()));
                    continue block19;
                }
                case 7: {
                    JsonArray jsonArray = new JsonArray();
                    NBTTagByteArray tagByteArray = (NBTTagByteArray)tag;
                    for (byte value : tagByteArray.func_150292_c()) {
                        jsonArray.add((JsonElement)new JsonPrimitive((Number)value));
                    }
                    result.add("B:" + tagName, (JsonElement)jsonArray);
                    continue block19;
                }
                case 8: {
                    result.add("S:" + tagName, (JsonElement)new JsonPrimitive(((NBTTagString)tag).func_150285_a_()));
                    continue block19;
                }
                case 9: {
                    NBTTagList tagList = (NBTTagList)tag;
                    JsonArray jsonArray = new JsonArray();
                    String typeId = "-";
                    switch (tagList.func_150303_d()) {
                        case 5: {
                            int i;
                            typeId = "f";
                            for (i = 0; i < tagList.func_74745_c(); ++i) {
                                jsonArray.add((JsonElement)new JsonPrimitive((Number)Float.valueOf(tagList.func_150308_e(i))));
                            }
                            break;
                        }
                        case 6: {
                            int i;
                            typeId = "d";
                            for (i = 0; i < tagList.func_74745_c(); ++i) {
                                jsonArray.add((JsonElement)new JsonPrimitive((Number)tagList.func_150309_d(i)));
                            }
                            break;
                        }
                        case 10: {
                            int i;
                            typeId = "c";
                            for (i = 0; i < tagList.func_74745_c(); ++i) {
                                jsonArray.add(context.serialize((Object)tagList.func_150305_b(i)));
                            }
                            break;
                        }
                        case 11: {
                            int i;
                            typeId = "i";
                            for (i = 0; i < tagList.func_74745_c(); ++i) {
                                int[] values;
                                JsonArray innerValues = new JsonArray();
                                for (int v : values = tagList.func_150306_c(i)) {
                                    innerValues.add((JsonElement)new JsonPrimitive((Number)v));
                                }
                                jsonArray.add((JsonElement)innerValues);
                            }
                            break;
                        }
                        default: {
                            throw new RuntimeException();
                        }
                    }
                    result.add(typeId + ":" + tagName, (JsonElement)jsonArray);
                    continue block19;
                }
                case 10: {
                    result.add("c:" + tagName, context.serialize((Object)tag, NBTTagCompound.class));
                    continue block19;
                }
                case 11: {
                    JsonArray jsonArray = new JsonArray();
                    NBTTagByteArray tagByteArray = (NBTTagByteArray)tag;
                    for (byte value : tagByteArray.func_150292_c()) {
                        jsonArray.add((JsonElement)new JsonPrimitive((Number)value));
                    }
                    result.add("I:" + tagName, (JsonElement)jsonArray);
                    continue block19;
                }
            }
            throw new RuntimeException();
        }
        return result;
    }

    public NBTTagCompound deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        try {
            JsonObject obj = json.getAsJsonObject();
            NBTTagCompound result = new NBTTagCompound();
            block12: for (Map.Entry tagData : obj.entrySet()) {
                char tagType = ((String)tagData.getKey()).charAt(0);
                String tagName = ((String)tagData.getKey()).substring(2, ((String)tagData.getKey()).length());
                switch (tagType) {
                    case 'b': {
                        result.func_74774_a(tagName, ((Byte)context.deserialize((JsonElement)tagData.getValue(), Byte.class)).byteValue());
                        continue block12;
                    }
                    case 'B': {
                        Object[] byteArray;
                        JsonArray jsonArray;
                        if (((JsonElement)tagData.getValue()).isJsonArray()) {
                            jsonArray = ((JsonElement)tagData.getValue()).getAsJsonArray();
                            byteArray = new byte[jsonArray.size()];
                            int index = 0;
                            for (JsonElement el : jsonArray) {
                                byteArray[index++] = (Byte)context.deserialize(el, Byte.class);
                            }
                            result.func_74782_a(tagName, (NBTBase)new NBTTagByteArray(byteArray));
                            continue block12;
                        }
                        OutputHandler.felog.severe("Error parsing NBT data: Invalid data type");
                        continue block12;
                    }
                    case 's': {
                        result.func_74777_a(tagName, ((Short)context.deserialize((JsonElement)tagData.getValue(), Short.class)).shortValue());
                        continue block12;
                    }
                    case 'i': {
                        JsonArray jsonArray;
                        NBTTagList tagList;
                        if (((JsonElement)tagData.getValue()).isJsonArray()) {
                            tagList = new NBTTagList();
                            jsonArray = ((JsonElement)tagData.getValue()).getAsJsonArray();
                            for (JsonElement el : jsonArray) {
                                tagList.func_74742_a((NBTBase)new NBTTagInt(((Integer)context.deserialize(el, Integer.class)).intValue()));
                            }
                            result.func_74782_a(tagName, (NBTBase)tagList);
                            continue block12;
                        }
                        if (((JsonElement)tagData.getValue()).isJsonPrimitive()) {
                            result.func_74768_a(tagName, ((Integer)context.deserialize((JsonElement)tagData.getValue(), Integer.class)).intValue());
                            continue block12;
                        }
                        OutputHandler.felog.severe("Error parsing NBT data: Invalid data type");
                        continue block12;
                    }
                    case 'I': {
                        Object[] byteArray;
                        JsonArray jsonArray;
                        if (((JsonElement)tagData.getValue()).isJsonArray()) {
                            jsonArray = ((JsonElement)tagData.getValue()).getAsJsonArray();
                            byteArray = new int[jsonArray.size()];
                            int index = 0;
                            for (JsonElement el : jsonArray) {
                                byteArray[index++] = (Integer)context.deserialize(el, Integer.class);
                            }
                            result.func_74782_a(tagName, (NBTBase)new NBTTagIntArray((int[])byteArray));
                            continue block12;
                        }
                        OutputHandler.felog.severe("Error parsing NBT data: Invalid data type");
                        continue block12;
                    }
                    case 'f': {
                        JsonArray jsonArray;
                        NBTTagList tagList;
                        if (((JsonElement)tagData.getValue()).isJsonArray()) {
                            tagList = new NBTTagList();
                            jsonArray = ((JsonElement)tagData.getValue()).getAsJsonArray();
                            for (JsonElement el : jsonArray) {
                                tagList.func_74742_a((NBTBase)new NBTTagFloat(((Float)context.deserialize(el, Float.class)).floatValue()));
                            }
                            result.func_74782_a(tagName, (NBTBase)tagList);
                            continue block12;
                        }
                        if (((JsonElement)tagData.getValue()).isJsonPrimitive()) {
                            result.func_74776_a(tagName, ((Float)context.deserialize((JsonElement)tagData.getValue(), Float.class)).floatValue());
                            continue block12;
                        }
                        OutputHandler.felog.severe("Error parsing NBT data: Invalid data type");
                        continue block12;
                    }
                    case 'd': {
                        JsonArray jsonArray;
                        NBTTagList tagList;
                        if (((JsonElement)tagData.getValue()).isJsonArray()) {
                            tagList = new NBTTagList();
                            jsonArray = ((JsonElement)tagData.getValue()).getAsJsonArray();
                            for (JsonElement el : jsonArray) {
                                tagList.func_74742_a((NBTBase)new NBTTagDouble(((Double)context.deserialize(el, Double.class)).doubleValue()));
                            }
                            result.func_74782_a(tagName, (NBTBase)tagList);
                            continue block12;
                        }
                        if (((JsonElement)tagData.getValue()).isJsonPrimitive()) {
                            result.func_74780_a(tagName, ((Double)context.deserialize((JsonElement)tagData.getValue(), Double.class)).doubleValue());
                            continue block12;
                        }
                        OutputHandler.felog.severe("Error parsing NBT data: Invalid data type");
                        continue block12;
                    }
                    case 'c': {
                        JsonArray jsonArray;
                        NBTTagList tagList;
                        if (((JsonElement)tagData.getValue()).isJsonArray()) {
                            tagList = new NBTTagList();
                            jsonArray = ((JsonElement)tagData.getValue()).getAsJsonArray();
                            for (JsonElement el : jsonArray) {
                                tagList.func_74742_a((NBTBase)((NBTTagCompound)context.deserialize(el, NBTTagCompound.class)));
                            }
                            result.func_74782_a(tagName, (NBTBase)tagList);
                            continue block12;
                        }
                        if (((JsonElement)tagData.getValue()).isJsonObject()) {
                            result.func_74782_a(tagName, (NBTBase)((NBTTagCompound)context.deserialize((JsonElement)tagData.getValue(), NBTTagCompound.class)));
                            continue block12;
                        }
                        OutputHandler.felog.severe("Error parsing NBT data: Invalid data type");
                        continue block12;
                    }
                }
                OutputHandler.felog.severe("Error parsing NBT data: Invalid data type");
            }
            return result;
        }
        catch (Throwable e) {
            OutputHandler.felog.severe(String.format("Error parsing data: %s", json.toString()));
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Class<NBTTagCompound> getType() {
        return NBTTagCompound.class;
    }
}

