/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.data.v2.types;

import com.forgeessentials.data.v2.DataManager;
import com.forgeessentials.util.OutputHandler;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import cpw.mods.fml.common.registry.GameData;
import java.lang.reflect.Type;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ItemStackType
implements DataManager.DataType<ItemStack> {
    private static final String DAMAGE = "damage";
    private static final String STACK_SIZE = "stackSize";
    private static final String ITEM_ID = "itemID";

    private static int getSafeJsonInt(JsonElement element, int defaultValue) {
        if (element == null || !element.isJsonPrimitive()) {
            return defaultValue;
        }
        JsonPrimitive primitive = element.getAsJsonPrimitive();
        try {
            return primitive.getAsInt();
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public JsonElement serialize(ItemStack src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject result = new JsonObject();
        result.add(ITEM_ID, (JsonElement)new JsonPrimitive(GameData.getItemRegistry().func_148750_c((Object)src.func_77973_b())));
        result.add(STACK_SIZE, (JsonElement)new JsonPrimitive((Number)src.field_77994_a));
        result.add(DAMAGE, (JsonElement)new JsonPrimitive((Number)src.func_77960_j()));
        if (src.func_77978_p() != null) {
            result.add("compound", context.serialize((Object)src.func_77978_p()));
        }
        return result;
    }

    public ItemStack deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        try {
            JsonObject obj = json.getAsJsonObject();
            String itemID = obj.get(ITEM_ID).getAsString();
            int stackSize = ItemStackType.getSafeJsonInt(obj.get(STACK_SIZE), 1);
            int damage2 = ItemStackType.getSafeJsonInt(obj.get(DAMAGE), 0);
            Item item = (Item)GameData.getItemRegistry().func_82594_a(itemID);
            if (item == null) {
                return null;
            }
            ItemStack stack = new ItemStack(item, stackSize, damage2);
            if (obj.has("compound")) {
                stack.func_77982_d((NBTTagCompound)context.deserialize(obj.get("compound"), NBTTagCompound.class));
            }
            return stack;
        }
        catch (Throwable e) {
            OutputHandler.felog.severe(String.format("Error parsing data: %s", json.toString()));
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Class<ItemStack> getType() {
        return ItemStack.class;
    }
}

