/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.data.v2;

import com.forgeessentials.commons.SaveableObject;
import com.forgeessentials.data.v2.types.ItemStackType;
import com.forgeessentials.data.v2.types.NBTTagCompoundType;
import com.forgeessentials.data.v2.types.UserIdentType;
import com.forgeessentials.util.OutputHandler;
import com.google.common.base.Throwables;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.Expose;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public class DataManager
implements ExclusionStrategy {
    private static DataManager instance;
    private static Gson gson;
    private static Map<Class<?>, JsonSerializer<?>> serializers;
    private static Map<Class<?>, JsonDeserializer<?>> deserializers;
    private static boolean formatsChanged;
    private File basePath;

    public DataManager(File basePath) {
        this.basePath = basePath;
    }

    public static DataManager getInstance() {
        if (instance == null) {
            throw new NullPointerException();
        }
        return instance;
    }

    public static void setInstance(DataManager instance) {
        DataManager.instance = instance;
    }

    public static void addDataType(DataType type) {
        serializers.put(type.getType(), type);
        deserializers.put(type.getType(), type);
        formatsChanged = true;
    }

    public static <T> void addSerializer(Class<T> clazz, JsonSerializer<T> type) {
        serializers.put(clazz, type);
        formatsChanged = true;
    }

    public static <T> void addDeserializer(Class<T> clazz, JsonDeserializer<T> type) {
        deserializers.put(clazz, type);
        formatsChanged = true;
    }

    public void save(Object src, String key) {
        try (FileWriter out = new FileWriter(this.getTypeFile(src.getClass(), key));){
            this.getGson().toJson(src, (Appendable)out);
        }
        catch (Throwable e) {
            Throwables.propagate((Throwable)e);
        }
    }

    public boolean delete(Class<?> clazz, String key) {
        File file = this.getTypeFile(clazz, key);
        return file.delete();
    }

    public <T> Map<String, T> loadAll(Class<T> clazz) {
        File[] files = this.getTypePath(clazz).listFiles();
        HashMap<String, T> objects = new HashMap<String, T>();
        if (files != null) {
            for (File file : files) {
                String key;
                T o;
                if (file.isDirectory() || !file.getName().endsWith(".json") || (o = this.load(clazz, key = file.getName().replace(".json", ""))) == null) continue;
                objects.put(key, o);
            }
        }
        return objects;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T load(Class<T> clazz, String key) {
        File file = this.getTypeFile(clazz, key);
        if (!file.exists()) {
            return null;
        }
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            Object object = this.getGson().fromJson((Reader)br, clazz);
            return (T)object;
        }
        catch (JsonParseException e) {
            OutputHandler.felog.severe(String.format("Error parsing data file \"%s\"", file.getAbsolutePath()));
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            OutputHandler.felog.severe(String.format("Error loading data file \"%s\"", file.getAbsolutePath()));
            e.printStackTrace();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T load(Type type, String key) {
        File file = this.getTypeFile(type.getClass(), key);
        if (!file.exists()) {
            return null;
        }
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            Object object = this.getGson().fromJson((Reader)br, type);
            return (T)object;
        }
        catch (JsonParseException e) {
            OutputHandler.felog.severe(String.format("Error parsing data file \"%s\"", file.getAbsolutePath()));
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            OutputHandler.felog.severe(String.format("Error loading data file \"%s\"", file.getAbsolutePath()));
            e.printStackTrace();
        }
        return null;
    }

    public boolean shouldSkipField(FieldAttributes f) {
        if (f.getDeclaringClass().getAnnotation(SaveableObject.class) != null && f.getAnnotation(SaveableObject.SaveableField.class) == null && f.getAnnotation(SaveableObject.UniqueLoadingKey.class) == null) {
            return true;
        }
        Expose expose = (Expose)f.getAnnotation(Expose.class);
        return expose != null && (!expose.serialize() || !expose.deserialize());
    }

    public boolean shouldSkipClass(Class<?> clazz) {
        return false;
    }

    private Gson getGson() {
        if (gson == null || formatsChanged) {
            GsonBuilder builder = new GsonBuilder();
            builder.setPrettyPrinting();
            builder.setExclusionStrategies(new ExclusionStrategy[]{this});
            for (Map.Entry<Class<?>, JsonSerializer<?>> entry : serializers.entrySet()) {
                builder.registerTypeAdapter((Type)entry.getKey(), entry.getValue());
            }
            for (Map.Entry<Class<?>, JsonSerializer<?>> entry : deserializers.entrySet()) {
                builder.registerTypeAdapter((Type)entry.getKey(), entry.getValue());
            }
            gson = builder.create();
        }
        return gson;
    }

    private File getTypePath(Class<?> clazz) {
        File path = new File(this.basePath, clazz.getSimpleName());
        path.mkdirs();
        return path;
    }

    private File getTypeFile(Class<?> clazz, String key) {
        return new File(this.getTypePath(clazz), key + ".json");
    }

    static {
        serializers = new HashMap();
        deserializers = new HashMap();
        DataManager.addDataType(new UserIdentType());
        DataManager.addDataType(new ItemStackType());
        DataManager.addDataType(new NBTTagCompoundType());
    }

    public static interface DataType<T>
    extends JsonSerializer<T>,
    JsonDeserializer<T> {
        public Class<T> getType();
    }
}

