/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.core.preloader.classloading;

import com.forgeessentials.core.preloader.FEPreLoader;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class FEClassLoader {
    private static final FilenameFilter jarFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".jar");
        }
    };
    private File FEfolder;
    private boolean reExtract;
    private static String[] compulsoryLibs = new String[]{"com.mysql.jdbc.Driver", "org.pircbotx.PircBotX", "org.h2.Driver"};
    private static final int BUFFER_SIZE = 4096;

    public void extractLibs(File mcLocation) {
        File libfolder;
        this.FEfolder = new File(mcLocation, "ForgeEssentials/");
        if (!this.FEfolder.exists()) {
            this.FEfolder.mkdirs();
        }
        if (!(libfolder = new File(this.FEfolder, "lib/")).exists()) {
            System.out.println("[ForgeEssentials] Could not find library folder - will create new one and re-extract libraries.");
            this.reExtract = true;
        }
        if (FEPreLoader.runtimeDeobfEnabled) {
            System.out.println("[ForgeEssentials] Checking if we need to extract libraries");
            if (this.reExtract) {
                System.out.println("[ForgeEssentials] Extracting libraries");
                File lib = new File(this.FEfolder, "lib/");
                if (lib.exists()) {
                    lib.delete();
                }
                try {
                    ZipEntry entry;
                    ZipInputStream zin = new ZipInputStream(this.getClass().getResourceAsStream("/libraries.zip"));
                    while ((entry = zin.getNextEntry()) != null) {
                        String name = entry.getName();
                        if (entry.isDirectory()) {
                            FEClassLoader.mkdirs(mcLocation, name);
                            continue;
                        }
                        String dir = FEClassLoader.dirpart(name);
                        if (dir != null) {
                            FEClassLoader.mkdirs(mcLocation, dir);
                        }
                        FEClassLoader.extractFile(zin, mcLocation, name);
                    }
                    zin.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        this.runClassLoad(this.FEfolder);
    }

    public void runClassLoad(File root) {
        File lib = new File(root, "lib/");
        if (!lib.exists()) {
            lib.mkdirs();
            System.err.println("[ForgeEssentials] Something happened that shouldn't have happened. Trying to recover.");
        }
        for (File f : lib.listFiles(jarFilter)) {
            if (f == null) continue;
            try {
                FEPreLoader.classLoader.addURL(f.toURI().toURL());
                System.out.println("[ForgeEssentials] Loaded library file " + f.getAbsolutePath());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Could not add library file " + f.getAbsolutePath() + ", there may be a classloading problem.");
            }
        }
        File module = new File(root, "modules/");
        if (!module.exists()) {
            module.mkdirs();
        }
        for (File f : module.listFiles(jarFilter)) {
            if (f == null) continue;
            try {
                FEPreLoader.classLoader.addURL(f.toURI().toURL());
            }
            catch (MalformedURLException e) {
                System.err.println("[ForgeEssentials] Could not add module file " + f.getAbsolutePath() + ", there may be a class loading problem.");
            }
        }
        System.out.println("[ForgeEssentials] Loaded " + module.listFiles().length + " modules");
        this.checkLibs();
    }

    public void checkLibs() {
        ArrayList<String> erroredLibs = new ArrayList<String>();
        for (String clazz : compulsoryLibs) {
            try {
                Class.forName(clazz);
                System.out.println("[ForgeEssentials] Found library " + clazz);
            }
            catch (ClassNotFoundException cnfe) {
                erroredLibs.add(clazz);
            }
        }
        if (!erroredLibs.isEmpty()) {
            System.err.println("[ForgeEssentials] You are missing the following library files.");
            for (Object error : erroredLibs.toArray()) {
                System.err.println(error);
            }
            System.err.println("[ForgeEssentials] Delete the 'lib' folder in your ForgeEssentials folder to fix this.");
            throw new RuntimeException("[ForgeEssentials] You are missing one or more library files. See your FML log for details.");
        }
    }

    private static void extractFile(ZipInputStream in, File outdir, String name) throws IOException {
        byte[] buffer = new byte[4096];
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(new File(outdir, name)));
        int count = -1;
        while ((count = in.read(buffer)) != -1) {
            out.write(buffer, 0, count);
        }
        out.close();
    }

    private static void mkdirs(File outdir, String path) {
        File d = new File(outdir, path);
        if (!d.exists()) {
            d.mkdirs();
        }
    }

    private static String dirpart(String name) {
        int s = name.lastIndexOf(File.separatorChar);
        return s == -1 ? null : name.substring(0, s);
    }
}

