/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.core.preloader.asm;

import com.forgeessentials.core.preloader.FEPreLoader;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class EventInjector
implements IClassTransformer {
    private static final Map<String, ClassPatch> classPatches = new THashMap();
    public static final List<String> injectedPatches = new ArrayList<String>();

    public static void addClassPatch(ClassPatch classPatch) {
        for (MethodMapping mm : classPatch.methodMappings) {
            System.out.println("Adding patch for method " + mm.getName() + " from class " + classPatch.targetClass);
        }
        classPatches.put(classPatch.targetClass, classPatch);
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (classPatches.containsKey(transformedName)) {
            ClassPatch cp = classPatches.get(transformedName);
            ClassNode cn = new ClassNode();
            ClassReader cr = new ClassReader(bytes);
            cr.accept((ClassVisitor)cn, 0);
            Iterator iter = cn.methods.iterator();
            while (iter.hasNext()) {
                MethodNode mn = (MethodNode)iter.next();
                for (MethodMapping mm : cp.methodMappings) {
                    if (!mm.getName().equals(mn.name) || !mm.desc.equals(mn.desc)) continue;
                    iter.remove();
                }
            }
            ClassWriter cw = new ClassWriter(0);
            cn.accept((ClassVisitor)cw);
            for (MethodMapping mm : cp.methodMappings) {
                mm.defineMethod(cw);
                injectedPatches.add(mm.friendlyName);
            }
            System.out.println("Injected patches for class " + transformedName);
            return cw.toByteArray();
        }
        return bytes;
    }

    public static abstract class MethodMapping {
        public final String srgName;
        public final String mcpName;
        public final String desc;
        public final String friendlyName;

        public MethodMapping(String srgName, String mcpName, String desc, String friendlyName) {
            this.srgName = srgName;
            this.mcpName = mcpName;
            this.desc = desc;
            this.friendlyName = friendlyName;
        }

        public String getName() {
            if (FEPreLoader.runtimeDeobfEnabled) {
                return this.srgName;
            }
            return this.mcpName;
        }

        public abstract void defineMethod(ClassWriter var1);
    }

    public static class ClassPatch {
        public final String targetClass;
        public final Set<MethodMapping> methodMappings = new THashSet();

        public ClassPatch(String targetClass) {
            this.targetClass = targetClass;
        }
    }
}

