/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.core.moduleLauncher.config;

import com.forgeessentials.core.moduleLauncher.config.IConfigLoader;
import com.forgeessentials.util.OutputHandler;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.common.config.Configuration;

public class ConfigManager {
    private File rootDirectory;
    private Map<String, ConfigFile> configFiles = new HashMap<String, ConfigFile>();
    private boolean useCanonicalConfig = false;
    private String mainConfigName;

    public ConfigManager(File rootDirectory, String mainConfigName) {
        this.rootDirectory = rootDirectory;
        this.mainConfigName = mainConfigName;
        this.load(false);
    }

    private ConfigFile getConfigFile(String configName) {
        ConfigFile loaders = this.configFiles.get(configName);
        if (loaders == null) {
            loaders = new ConfigFile(new File(this.rootDirectory, configName + ".cfg"));
            this.configFiles.put(configName, loaders);
        }
        return loaders;
    }

    public Configuration getConfig(String configName) {
        return this.getConfigFile((String)configName).config;
    }

    public void registerLoader(String configName, IConfigLoader loader) {
        this.registerLoader(configName, loader, true);
    }

    public void registerLoader(String configName, IConfigLoader loader, boolean loadAfterRegistration) {
        if (this.useCanonicalConfig && loader.supportsCanonicalConfig()) {
            this.getConfigFile((String)this.mainConfigName).loaders.add(loader);
        } else {
            this.getConfigFile((String)configName).loaders.add(loader);
        }
        if (loadAfterRegistration) {
            this.load(false);
        }
    }

    public void load(boolean reload) {
        OutputHandler.felog.finer("Loading configuration files");
        boolean changed = false;
        for (ConfigFile file : this.configFiles.values()) {
            if (reload) {
                file.config.load();
            }
            for (IConfigLoader loader : file.loaders) {
                if (!reload) {
                    if (file.loaded.contains(loader)) continue;
                    file.loaded.add(loader);
                }
                changed |= true;
                loader.load(file.config, reload);
            }
            if (!changed) continue;
            file.config.save();
        }
        OutputHandler.felog.finer("Finished loading configuration files");
    }

    public void saveAll() {
        OutputHandler.felog.finer("Saving configuration files");
        for (ConfigFile file : this.configFiles.values()) {
            file.config.load();
            for (IConfigLoader loader : file.loaders) {
                loader.save(file.config);
            }
            file.config.save();
        }
    }

    public void save(String configName) {
        ConfigFile file = this.getConfigFile(configName);
        for (IConfigLoader loader : file.loaders) {
            loader.save(file.config);
        }
        file.config.save();
    }

    public boolean isUseCanonicalConfig() {
        return this.useCanonicalConfig;
    }

    public void setUseCanonicalConfig(boolean useCanonicalConfig) {
        this.useCanonicalConfig = useCanonicalConfig;
    }

    public String getMainConfigName() {
        return this.mainConfigName;
    }

    public Configuration getMainConfig() {
        return this.getConfig(this.mainConfigName);
    }

    private static class ConfigFile {
        public Configuration config;
        public Set<IConfigLoader> loaders = new HashSet<IConfigLoader>();
        public Set<IConfigLoader> loaded = new HashSet<IConfigLoader>();

        public ConfigFile(File path) {
            this.config = new Configuration(path, true);
        }
    }
}

