/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.core.moduleLauncher;

import com.forgeessentials.api.APIRegistry;
import com.forgeessentials.core.ForgeEssentials;
import com.forgeessentials.core.moduleLauncher.CallableMap;
import com.forgeessentials.core.moduleLauncher.FEModule;
import com.forgeessentials.core.moduleLauncher.ModuleContainer;
import com.forgeessentials.core.moduleLauncher.config.IConfigLoader;
import com.forgeessentials.util.FunctionHelper;
import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.util.events.FEModuleEvent;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.command.ICommandSender;

public class ModuleLauncher {
    public static ModuleLauncher instance;
    private static TreeMap<String, ModuleContainer> containerMap;

    public ModuleLauncher() {
        instance = this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void preLoad(FMLPreInitializationEvent e) {
        OutputHandler.felog.info("Discovering and loading modules...");
        Set data = e.getAsmData().getAll(FEModule.class.getName());
        for (ASMDataTable.ASMData asm : data) {
            ModuleContainer temp;
            block14: {
                temp = new ModuleContainer(asm);
                if (!temp.isLoadable) continue;
                if (containerMap.containsKey(temp.name)) {
                    ModuleContainer other = containerMap.get(temp.name);
                    if (temp.doesOverride && other.mod == ForgeEssentials.instance) {
                        containerMap.put(temp.name, temp);
                        break block14;
                    } else {
                        if (temp.mod == ForgeEssentials.instance && other.doesOverride) continue;
                        throw new RuntimeException("{FE-Module-Launcher} " + temp.name + " is conflicting with " + other.name);
                    }
                }
                containerMap.put(temp.name, temp);
            }
            temp.createAndPopulate();
            OutputHandler.felog.info("Loaded " + temp.name);
        }
        CallableMap map = new CallableMap();
        data = e.getAsmData().getAll(APIRegistry.ForgeEssentialsRegistrar.class.getName());
        Object obj = null;
        for (ASMDataTable.ASMData asm : data) {
            try {
                obj = null;
                Class<?> c = Class.forName(asm.getClassName());
                try {
                    obj = c.newInstance();
                    map.scanObject(obj);
                }
                catch (Exception e1) {
                    map.scanClass(c);
                }
            }
            catch (ClassNotFoundException e1) {}
        }
        for (ModContainer container : Loader.instance().getModList()) {
            if (container.getMod() == null) continue;
            map.scanObject(container);
        }
        for (ModuleContainer module : containerMap.values()) {
            map.scanObject(module);
        }
        Iterator<Object> i$ = containerMap.values().iterator();
        while (true) {
            ModuleContainer module;
            if (!i$.hasNext()) {
                FunctionHelper.FE_INTERNAL_EVENTBUS.post((Event)new FEModuleEvent.FEModulePreInitEvent(e));
                ForgeEssentials.getConfigManager().load(false);
                return;
            }
            module = (ModuleContainer)i$.next();
            if (module.module instanceof IConfigLoader) {
                OutputHandler.felog.info("Registering configuration for FE module " + module.name);
                ForgeEssentials.getConfigManager().registerLoader(module.name, (IConfigLoader)module.module, false);
                continue;
            }
            OutputHandler.felog.info("No configuration for FE module " + module.name);
        }
    }

    public void reloadConfigs(ICommandSender sender) {
        ForgeEssentials.getConfigManager().load(true);
        for (ModuleContainer module : containerMap.values()) {
            module.runReload(sender);
        }
    }

    public void unregister(String moduleName) {
        ModuleContainer container = containerMap.get(moduleName);
        FunctionHelper.FE_INTERNAL_EVENTBUS.unregister(container.module);
        containerMap.remove(moduleName);
    }

    public static Collection<String> getModuleList() {
        return containerMap.keySet();
    }

    public static Map<String, ModuleContainer> getModuleMap() {
        return containerMap;
    }

    static {
        containerMap = new TreeMap();
    }
}

