/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.core.moduleLauncher;

import com.forgeessentials.core.ForgeEssentials;
import com.forgeessentials.core.moduleLauncher.FEModule;
import com.forgeessentials.util.FunctionHelper;
import com.forgeessentials.util.OutputHandler;
import com.google.common.base.Throwables;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.discovery.ASMDataTable;
import java.io.File;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import net.minecraft.command.ICommandSender;

public class ModuleContainer
implements Comparable {
    protected static HashSet<Class> modClasses = new HashSet();
    public Object module;
    public Object mod;
    private String reload;
    private String instance;
    private String container;
    private String parentMod;
    private String moduleDir;
    public final String className;
    public final String name;
    private final boolean isCore;
    public boolean isLoadable = true;
    protected boolean doesOverride;

    public ModuleContainer(ASMDataTable.ASMData data) {
        Class<?> c = null;
        this.className = data.getClassName();
        try {
            c = Class.forName(this.className);
        }
        catch (Throwable e) {
            OutputHandler.felog.info("Error trying to load " + data.getClassName() + " as a FEModule!");
            e.printStackTrace();
            this.isCore = false;
            this.name = "INVALID-MODULE";
            return;
        }
        if (!c.isAnnotationPresent(FEModule.class)) {
            throw new IllegalArgumentException(c.getName() + " doesn't have the @FEModule annotation!");
        }
        FEModule annot = c.getAnnotation(FEModule.class);
        if (annot == null) {
            throw new IllegalArgumentException(c.getName() + " doesn't have the @FEModule annotation!");
        }
        this.name = annot.name();
        this.isCore = annot.isCore();
        this.doesOverride = annot.doesOverride();
        if (annot.canDisable() && !ForgeEssentials.getConfigManager().getMainConfig().get("Core.Modules", this.name, true).getBoolean(true)) {
            OutputHandler.felog.info("Requested to disable module " + this.name);
            this.isLoadable = false;
            return;
        }
        this.mod = ModuleContainer.handleMod(annot.parentMod());
        for (Method method : c.getDeclaredMethods()) {
            Class<?>[] params;
            if (method.isAnnotationPresent(FEModule.Reload.class)) {
                if (this.reload != null) {
                    throw new RuntimeException("Only one method may be marked as Reload");
                }
                params = method.getParameterTypes();
                if (params.length != 1) {
                    throw new RuntimeException(method + " may only have 1 argument!");
                }
                if (!params[0].equals(ICommandSender.class)) {
                    throw new RuntimeException(method + " must take " + ICommandSender.class.getSimpleName() + " as a param!");
                }
                method.setAccessible(true);
                this.reload = method.getName();
                continue;
            }
            if (!method.isAnnotationPresent(FEModule.Preconditions.class)) continue;
            params = method.getParameterTypes();
            if (params.length != 0) {
                throw new RuntimeException(method + " must take no arguments!");
            }
            if (!method.getReturnType().equals(Boolean.TYPE)) {
                throw new RuntimeException(method + " must return a boolean!");
            }
            method.setAccessible(true);
            try {
                if (((Boolean)method.invoke(c.newInstance(), new Object[0])).booleanValue()) continue;
                OutputHandler.felog.info("Requested to disable module " + this.name);
                this.isLoadable = false;
                return;
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
        for (AccessibleObject accessibleObject : c.getDeclaredFields()) {
            if (accessibleObject.isAnnotationPresent(FEModule.Instance.class)) {
                if (this.instance != null) {
                    throw new RuntimeException("Only one field may be marked as Instance");
                }
                ((Field)accessibleObject).setAccessible(true);
                this.instance = ((Field)accessibleObject).getName();
                continue;
            }
            if (accessibleObject.isAnnotationPresent(FEModule.Container.class)) {
                if (this.container != null) {
                    throw new RuntimeException("Only one field may be marked as Container");
                }
                if (((Field)accessibleObject).getType().equals(ModuleContainer.class)) {
                    throw new RuntimeException("This field must have the type ModuleContainer!");
                }
                ((Field)accessibleObject).setAccessible(true);
                this.container = ((Field)accessibleObject).getName();
                continue;
            }
            if (accessibleObject.isAnnotationPresent(FEModule.ParentMod.class)) {
                if (this.parentMod != null) {
                    throw new RuntimeException("Only one field may be marked as ParentMod");
                }
                ((Field)accessibleObject).setAccessible(true);
                this.parentMod = ((Field)accessibleObject).getName();
                continue;
            }
            if (!accessibleObject.isAnnotationPresent(FEModule.ModuleDir.class)) continue;
            if (this.moduleDir != null) {
                throw new RuntimeException("Only one field may be marked as ModuleDir");
            }
            if (!File.class.isAssignableFrom(((Field)accessibleObject).getType())) {
                throw new RuntimeException("This field must be the type File!");
            }
            ((Field)accessibleObject).setAccessible(true);
            this.moduleDir = ((Field)accessibleObject).getName();
        }
    }

    protected void createAndPopulate() {
        Class<?> c;
        try {
            c = Class.forName(this.className);
            this.module = c.newInstance();
        }
        catch (Throwable e) {
            OutputHandler.felog.warning(this.name + " could not be instantiated. FE will not load this module.");
            e.printStackTrace();
            this.isLoadable = false;
            return;
        }
        FunctionHelper.FE_INTERNAL_EVENTBUS.register(this.module);
        try {
            Field f;
            if (this.instance != null) {
                f = c.getDeclaredField(this.instance);
                f.setAccessible(true);
                f.set(this.module, this.module);
            }
            if (this.container != null) {
                f = c.getDeclaredField(this.container);
                f.setAccessible(true);
                f.set(this.module, this);
            }
            if (this.parentMod != null) {
                f = c.getDeclaredField(this.parentMod);
                f.setAccessible(true);
                f.set(this.module, this.mod);
            }
            if (this.moduleDir != null) {
                File file = new File(ForgeEssentials.getFEDirectory(), this.name);
                file.mkdirs();
                f = c.getDeclaredField(this.moduleDir);
                f.setAccessible(true);
                f.set(this.module, file);
            }
        }
        catch (Throwable e) {
            OutputHandler.felog.info("Error populating fields of " + this.name);
            Throwables.propagate((Throwable)e);
        }
    }

    public void runReload(ICommandSender user) {
        if (!this.isLoadable || this.reload == null) {
            return;
        }
        try {
            Class<?> c = Class.forName(this.className);
            Method m = c.getDeclaredMethod(this.reload, ICommandSender.class);
            m.invoke(this.module, user);
        }
        catch (Throwable e) {
            OutputHandler.felog.info("Error while invoking Reload method for " + this.name);
            Throwables.propagate((Throwable)e);
        }
    }

    public File getModuleDir() {
        return new File(ForgeEssentials.getFEDirectory(), this.name);
    }

    public int compareTo(Object o) {
        if (!(o instanceof ModuleContainer)) {
            return -1;
        }
        ModuleContainer other = (ModuleContainer)o;
        if (this.equals(other)) {
            return 0;
        }
        if (this.isCore && !other.isCore) {
            return 1;
        }
        if (!this.isCore && other.isCore) {
            return -1;
        }
        return this.name.compareTo(other.name);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ModuleContainer)) {
            return false;
        }
        ModuleContainer c = (ModuleContainer)o;
        return this.isCore == c.isCore && this.name.equals(c.name) && this.className.equals(c.className);
    }

    public int hashCode() {
        return (11 + this.name.hashCode()) * 29 + this.className.hashCode();
    }

    private static Object handleMod(Class c) {
        Object obj = null;
        ModContainer contain = null;
        for (ModContainer container : Loader.instance().getModList()) {
            if (container.getMod() == null || !container.getMod().getClass().equals(c)) continue;
            contain = container;
            obj = container.getMod();
            break;
        }
        if (obj == null || contain == null) {
            throw new RuntimeException(c + " isn't an loaded mod class!");
        }
        String modid = contain.getModId() + "--" + contain.getVersion();
        if (modClasses.add(c)) {
            OutputHandler.felog.info("Modules from " + modid + " are being loaded");
        }
        return obj;
    }
}

