/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.core.moduleLauncher;

import com.forgeessentials.api.APIRegistry;
import com.forgeessentials.core.moduleLauncher.FEModule;
import com.forgeessentials.core.moduleLauncher.ModuleContainer;
import com.forgeessentials.util.OutputHandler;
import com.google.common.collect.HashMultimap;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Set;

public class CallableMap {
    private HashMultimap<String, FECallable> callables = HashMultimap.create();

    public void scanObject(Object obj) {
        if (obj == null) {
            return;
        }
        try {
            Class<?> c = obj.getClass();
            if (obj instanceof ModContainer) {
                c = ((ModContainer)obj).getMod().getClass();
            } else if (obj instanceof ModuleContainer) {
                c = ((ModuleContainer)obj).module.getClass();
            }
            for (Method m : c.getDeclaredMethods()) {
                SideOnly annot;
                if (m.isAnnotationPresent(SideOnly.class) && !(annot = m.getAnnotation(SideOnly.class)).value().equals((Object)FMLCommonHandler.instance().getSide())) continue;
                FECallable call = Modifier.isStatic(m.getModifiers()) ? new FECallable(m) : new FECallable(m, obj);
                for (Annotation annot2 : m.getAnnotations()) {
                    String name = annot2.annotationType().getName();
                    this.callables.put((Object)name, (Object)call);
                }
            }
        }
        catch (Throwable e) {
            OutputHandler.felog.severe("Error stripping methods from class! " + obj.getClass().getName());
        }
    }

    public void scanClass(Class<?> c) {
        if (c == null) {
            return;
        }
        try {
            for (Method m : c.getDeclaredMethods()) {
                SideOnly annot;
                if (m.isAnnotationPresent(SideOnly.class) && !(annot = m.getAnnotation(SideOnly.class)).value().equals((Object)FMLCommonHandler.instance().getSide()) || !Modifier.isStatic(m.getModifiers())) continue;
                FECallable call = new FECallable(m);
                for (Annotation annot2 : m.getAnnotations()) {
                    String name = annot2.annotationType().getName();
                    this.callables.put((Object)name, (Object)call);
                }
            }
        }
        catch (Throwable e) {
            OutputHandler.felog.severe("Error stripping methods from class! " + c.getName());
        }
    }

    public Set<FECallable> getCallable(Class<? extends Annotation> annot) {
        return this.callables.get((Object)annot.getName());
    }

    public Set<FECallable> getCallable(String annotName) {
        return this.callables.get((Object)annotName);
    }

    public static final class FECallable {
        private Method method;
        private Object instance = null;
        private String ident;

        FECallable(Method m, Object instance) {
            this(m);
            if (instance == null) {
                this.instance = instance;
            } else if (instance instanceof ModContainer) {
                this.instance = ((ModContainer)instance).getMod();
                this.ident = ((ModContainer)instance).getModId();
            } else if (instance instanceof ModuleContainer) {
                this.instance = ((ModuleContainer)instance).module;
                this.ident = ((ModuleContainer)instance).name;
            } else {
                this.instance = instance;
            }
        }

        FECallable(Method m) {
            this.method = m;
            Class<?> c = m.getDeclaringClass();
            this.ident = c.isAnnotationPresent(Mod.class) ? c.getAnnotation(Mod.class).modid() : (c.isAnnotationPresent(FEModule.class) ? c.getAnnotation(FEModule.class).name() : (c.isAnnotationPresent(APIRegistry.ForgeEssentialsRegistrar.class) ? c.getAnnotation(APIRegistry.ForgeEssentialsRegistrar.class).ident() : "UNKNOWN"));
        }

        public boolean isStatic() {
            return this.instance == null;
        }

        public boolean hasReturn() {
            return !this.method.getReturnType().equals(Void.TYPE);
        }

        public Class<?> getReturn() {
            return this.method.getReturnType();
        }

        public Class<?>[] getParameters() {
            return this.method.getParameterTypes();
        }

        public Object call(Object ... args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this.method.setAccessible(true);
            return this.method.invoke(this.instance, args);
        }

        public Annotation getAnnotation(Class annot) {
            return this.method.getAnnotation(annot);
        }

        public Annotation getClassAnnotation(Class annot) {
            return this.method.getDeclaringClass().getAnnotation(annot);
        }

        public String getIdent() {
            return this.ident;
        }
    }
}

