/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.core.misc;

import com.forgeessentials.util.events.ServerEventHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TickTaskHandler
extends ServerEventHandler {
    public static final int MAX_BLOCK_CHANGES = 128;
    private static int changedBlocks;
    private static List<TickTask> tasks;

    @SubscribeEvent
    public void serverTickEvent(TickEvent.ServerTickEvent e) {
        changedBlocks = 0;
        Iterator<TickTask> it = tasks.iterator();
        while (it.hasNext()) {
            TickTask task = it.next();
            task.tick();
            if (!task.isComplete()) continue;
            task.onComplete();
            it.remove();
        }
    }

    public static boolean changeBlock() {
        return ++changedBlocks < 128;
    }

    public static void schedule(TickTask task) {
        tasks.add(task);
    }

    static {
        tasks = new ArrayList<TickTask>();
    }

    public static interface TickTask {
        public void tick();

        public void onComplete();

        public boolean isComplete();
    }
}

