/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.core.misc;

import com.forgeessentials.api.APIRegistry;
import com.forgeessentials.commons.selections.WarpPoint;
import com.forgeessentials.util.FunctionHelper;
import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.util.PlayerInfo;
import com.forgeessentials.util.UserIdent;
import com.forgeessentials.util.events.ServerEventHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S07PacketRespawn;
import net.minecraft.network.play.server.S1DPacketEntityEffect;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.world.Teleporter;
import net.minecraft.world.WorldServer;

public class TeleportHelper
extends ServerEventHandler {
    public static final String TELEPORT_COOLDOWN = "fe.teleport.cooldown";
    public static final String TELEPORT_WARMUP = "fe.teleport.warmup";
    public static final String TELEPORT_FROM = "fe.teleport.from";
    public static final String TELEPORT_TO = "fe.teleport.to";
    private static Map<UUID, TeleportInfo> tpInfos = new HashMap<UUID, TeleportInfo>();

    public static void teleport(EntityPlayerMP player, WarpPoint point) {
        PlayerInfo pi;
        long cooldownDuration;
        if (!APIRegistry.perms.checkPermission((EntityPlayer)player, TELEPORT_FROM)) {
            OutputHandler.chatError((ICommandSender)player, "You are not allowed to teleport from here.");
            return;
        }
        if (!APIRegistry.perms.checkUserPermission(new UserIdent(player), point.toWorldPoint(), TELEPORT_TO)) {
            OutputHandler.chatError((ICommandSender)player, "You are not allowed to teleport to that location.");
            return;
        }
        int teleportCooldown = FunctionHelper.parseIntDefault(APIRegistry.perms.getPermissionProperty((EntityPlayer)player, TELEPORT_COOLDOWN), 0) * 1000;
        if (teleportCooldown > 0 && (cooldownDuration = (pi = PlayerInfo.getPlayerInfo((EntityPlayer)player)).getLastTeleportTime() + (long)teleportCooldown - System.currentTimeMillis()) >= 0L) {
            OutputHandler.chatNotification((ICommandSender)player, String.format("Cooldown still active. %d seconds to go.", cooldownDuration / 1000L));
            return;
        }
        int teleportWarmup = FunctionHelper.parseIntDefault(APIRegistry.perms.getPermissionProperty((EntityPlayer)player, TELEPORT_WARMUP), 0);
        if (teleportWarmup <= 0) {
            TeleportHelper.doTeleport(player, point);
            return;
        }
        tpInfos.put(player.getPersistentID(), new TeleportInfo(player, point, teleportWarmup * 1000));
        OutputHandler.chatNotification((ICommandSender)player, String.format("Teleporting. Please stand still for %s.", FunctionHelper.parseTime(teleportWarmup)));
    }

    public static void doTeleport(EntityPlayerMP player, WarpPoint point) {
        PlayerInfo pi = PlayerInfo.getPlayerInfo((EntityPlayer)player);
        pi.setLastTeleportOrigin(new WarpPoint((Entity)player));
        pi.setLastTeleportTime(System.currentTimeMillis());
        if (player.field_71093_bK != point.getDimension()) {
            TeleportHelper.transferPlayerToDimension(player, point.getDimension());
        }
        player.field_70179_y = 0.0;
        player.field_70181_x = 0.0;
        player.field_70159_w = 0.0;
        player.field_71135_a.func_147364_a(point.getX(), point.getY() + 0.1, point.getZ(), point.getYaw(), point.getPitch());
    }

    @SubscribeEvent
    public void serverTickEvent(TickEvent.ServerTickEvent e) {
        if (e.phase == TickEvent.Phase.START) {
            Iterator<TeleportInfo> it = tpInfos.values().iterator();
            while (it.hasNext()) {
                TeleportInfo tpInfo = it.next();
                if (!tpInfo.check()) continue;
                it.remove();
            }
        }
    }

    public static void transferPlayerToDimension(EntityPlayerMP player, int dimId) {
        TeleportHelper.transferPlayerToDimension(player, dimId, MinecraftServer.func_71276_C().func_71218_a(dimId).func_85176_s());
    }

    public static void transferPlayerToDimension(EntityPlayerMP player, int dimId, Teleporter teleporter) {
        ServerConfigurationManager confMan = MinecraftServer.func_71276_C().func_71203_ab();
        int j = player.field_71093_bK;
        WorldServer worldserver = confMan.func_72365_p().func_71218_a(player.field_71093_bK);
        player.field_71093_bK = dimId;
        WorldServer worldserver1 = confMan.func_72365_p().func_71218_a(player.field_71093_bK);
        player.field_71135_a.func_147359_a((Packet)new S07PacketRespawn(player.field_71093_bK, worldserver1.field_73013_u, worldserver1.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
        worldserver.func_72973_f((Entity)player);
        player.field_70128_L = false;
        confMan.transferEntityToWorld((Entity)player, j, worldserver, worldserver1, teleporter);
        confMan.func_72375_a(player, worldserver);
        player.field_71135_a.func_147364_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, player.field_70125_A);
        player.field_71134_c.func_73080_a(worldserver1);
        confMan.func_72354_b(player, worldserver1);
        confMan.func_72385_f(player);
        for (PotionEffect potioneffect : player.func_70651_bq()) {
            player.field_71135_a.func_147359_a((Packet)new S1DPacketEntityEffect(player.func_145782_y(), potioneffect));
        }
        FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)player, j, dimId);
    }

    public static class TeleportInfo {
        private EntityPlayerMP player;
        private long start;
        private int timeout;
        private WarpPoint point;
        private WarpPoint playerPos;

        public TeleportInfo(EntityPlayerMP player, WarpPoint point, int timeout) {
            this.point = point;
            this.timeout = timeout;
            this.start = System.currentTimeMillis();
            this.player = player;
            this.playerPos = new WarpPoint((Entity)player);
        }

        public boolean check() {
            WarpPoint warpPoint = new WarpPoint((Entity)this.player);
            if (this.playerPos.getDistanceTo(warpPoint) > 0.2) {
                OutputHandler.chatWarning((ICommandSender)this.player, "Teleport cancelled.");
                return true;
            }
            if (System.currentTimeMillis() - this.start < (long)this.timeout) {
                return false;
            }
            TeleportHelper.doTeleport(this.player, this.point);
            OutputHandler.chatConfirmation((ICommandSender)this.player, "Teleported.");
            return true;
        }
    }
}

