/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.core.misc;

import com.forgeessentials.core.ForgeEssentials;
import com.forgeessentials.util.OutputHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.registry.GameData;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Calendar;
import net.minecraft.block.Block;
import net.minecraft.item.Item;

public class BlockModListFile {
    private static Calendar calen = Calendar.getInstance();

    public static void makeModList() {
        try {
            File modListFile = new File(ForgeEssentials.getFEDirectory(), ForgeEssentials.modlistLocation);
            if (modListFile.exists()) {
                modListFile.delete();
            }
            try (PrintWriter out = new PrintWriter(new FileWriter(modListFile));){
                out.println("# --- ModList ---");
                out.println("# Generated: " + calen.get(5) + "-" + calen.get(2) + "-" + calen.get(1) + " (Server time)");
                out.println("# Change the location of this file in " + ForgeEssentials.getConfigManager().getMainConfigName() + ".cfg");
                out.println();
                for (ModContainer mod : Loader.instance().getModList()) {
                    String url = "";
                    if (!mod.getMetadata().url.isEmpty()) {
                        url = mod.getMetadata().url;
                    }
                    if (!mod.getMetadata().updateUrl.isEmpty()) {
                        url = mod.getMetadata().updateUrl;
                    }
                    out.println(mod.getName() + ";" + mod.getVersion() + ";" + url);
                }
            }
        }
        catch (Exception e) {
            OutputHandler.felog.severe("Error writing the modlist file: " + ForgeEssentials.modlistLocation);
        }
    }

    public static void dumpFMLRegistries() {
        try {
            File modListFile = new File(ForgeEssentials.getFEDirectory(), "ItemList.txt");
            if (modListFile.exists()) {
                modListFile.delete();
            }
            try (PrintWriter out = new PrintWriter(new FileWriter(modListFile));){
                out.println("# --- Block/Item List ---");
                out.println("# Generated: " + calen.get(5) + "-" + calen.get(2) + "-" + calen.get(1) + " (Server time)");
                out.println();
                for (Item i : GameData.getItemRegistry().typeSafeIterable()) {
                    out.println(i.func_77658_a());
                }
                for (Block b : GameData.getBlockRegistry().typeSafeIterable()) {
                    out.println(b.func_149739_a());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

