/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.core.environment;

import com.forgeessentials.util.OutputHandler;
import com.google.common.collect.HashMultimap;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.command.CommandHandler;
import net.minecraft.command.ICommand;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fe.server.CommandHandlerForge;

public class CommandSetChecker {
    public static final String[] FIELDNAME = new String[]{"commandSet", "c", "field_71561_b", "z/c"};
    public static boolean removeDuplicateCommands;

    public static void remove() {
        OutputHandler.felog.finest("Running duplicate command removal process!");
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server.func_71187_D() instanceof CommandHandler) {
            try {
                ICommand keep;
                HashMap<String, ICommand> initials = new HashMap<String, ICommand>();
                HashMultimap duplicates = HashMultimap.create();
                Set cmdList = (Set)ReflectionHelper.getPrivateValue(CommandHandler.class, (Object)((CommandHandler)server.func_71187_D()), (String[])FIELDNAME);
                OutputHandler.felog.finer("commandSet size: " + cmdList.size());
                for (ICommand cmd : cmdList) {
                    keep = initials.put(cmd.func_71517_b(), cmd);
                    if (keep != null) {
                        OutputHandler.felog.finer("Duplicate command found! Name:" + keep.func_71517_b());
                        duplicates.put((Object)cmd.func_71517_b(), (Object)cmd);
                        duplicates.put((Object)cmd.func_71517_b(), (Object)keep);
                        continue;
                    }
                    CommandHandlerForge.doPermissionReg(cmd);
                }
                HashSet<ICommand> toRemove = new HashSet<ICommand>();
                keep = null;
                int kept = -1;
                int other = -1;
                for (String name : duplicates.keySet()) {
                    keep = null;
                    kept = -1;
                    other = -1;
                    Class<?> cmdClass = null;
                    for (ICommand cmd : duplicates.get((Object)name)) {
                        other = CommandSetChecker.getCommandPriority(cmd);
                        if (keep == null) {
                            kept = other;
                            if (kept == -1) {
                                keep = null;
                                duplicates.remove((Object)name, (Object)cmd);
                                continue;
                            }
                            keep = cmd;
                            continue;
                        }
                        if (kept > other) {
                            toRemove.add(cmd);
                            cmdClass = cmd.getClass();
                            OutputHandler.felog.finer("Removing command '" + cmd.func_71517_b() + "' from class: " + cmdClass.getName());
                            continue;
                        }
                        toRemove.add(keep);
                        cmdClass = keep.getClass();
                        OutputHandler.felog.finer("Removing command '" + keep.func_71517_b() + "' from class: " + cmdClass.getName());
                        keep = cmd;
                        kept = other;
                    }
                }
                cmdList.removeAll(toRemove);
                OutputHandler.felog.finer("commandSet size: " + cmdList.size());
                ReflectionHelper.setPrivateValue(CommandHandler.class, (Object)((CommandHandler)server.func_71187_D()), (Object)cmdList, (String[])FIELDNAME);
            }
            catch (Exception e) {
                OutputHandler.felog.finer("Something broke: " + e.getLocalizedMessage());
                e.printStackTrace();
            }
        }
    }

    private static int getCommandPriority(ICommand cmd) {
        try {
            Class<?> cmdClass = cmd.getClass();
            Package pkg = cmdClass.getPackage();
            if (pkg == null) {
                return 0;
            }
            if (pkg.getName().contains("net.minecraft")) {
                return 0;
            }
            if (pkg.getName().contains("forgeessentials")) {
                return 1;
            }
            return 2;
        }
        catch (Exception e) {
            OutputHandler.felog.finer("Can't remove " + cmd.func_71517_b());
            OutputHandler.felog.finer("" + e.getLocalizedMessage());
            e.printStackTrace();
            return -1;
        }
    }
}

