/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.core.commands;

import com.forgeessentials.api.APIRegistry;
import com.forgeessentials.util.UserIdent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandHandler;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.server.CommandBlockLogic;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntityCommandBlock;
import net.minecraftforge.fe.server.CommandHandlerForge;
import net.minecraftforge.permissions.PermissionContext;
import net.minecraftforge.permissions.PermissionsManager;

public abstract class ForgeEssentialsCommandBase
extends CommandBase {
    public void func_71515_b(ICommandSender sender, String[] args) {
        if (sender instanceof EntityPlayerMP) {
            this.processCommandPlayer((EntityPlayerMP)sender, args);
        } else if (sender instanceof TileEntityCommandBlock) {
            this.processCommandBlock((CommandBlockLogic)sender, args);
        } else {
            this.processCommandConsole(sender, args);
        }
    }

    public void processCommandPlayer(EntityPlayerMP sender, String[] args) {
        throw new CommandException(String.format("Command %s is not implemented for players", this.func_71517_b()), new Object[0]);
    }

    public void processCommandConsole(ICommandSender sender, String[] args) {
        throw new CommandException(String.format("Command %s is not implemented for console", this.func_71517_b()), new Object[0]);
    }

    public void processCommandBlock(CommandBlockLogic block, String[] args) {
        this.processCommandConsole((ICommandSender)block, args);
    }

    public boolean func_71519_b(ICommandSender sender) {
        if (sender instanceof EntityPlayer) {
            if (!this.canPlayerUseCommand((EntityPlayer)sender)) {
                return ForgeEssentialsCommandBase.canCommandSenderUseCommandException("This command cannot be used as player");
            }
        } else if (sender instanceof TileEntityCommandBlock) {
            if (!this.canCommandBlockUseCommand((TileEntityCommandBlock)sender)) {
                return ForgeEssentialsCommandBase.canCommandSenderUseCommandException("This command cannot be used by command-blocks");
            }
        } else if (!this.canConsoleUseCommand()) {
            return ForgeEssentialsCommandBase.canCommandSenderUseCommandException("This command cannot be used from console");
        }
        return this.checkCommandPermission(sender);
    }

    protected static boolean canCommandSenderUseCommandException(String msg) {
        String className = CommandHandler.class.getName();
        String methodName = "executeCommand";
        for (StackTraceElement s : Thread.currentThread().getStackTrace()) {
            if (!s.getClassName().equals(className)) continue;
            if (!s.getClassName().equals("executeCommand")) break;
            throw new CommandException(msg, new Object[0]);
        }
        return false;
    }

    public boolean canPlayerUseCommand(EntityPlayer player) {
        return true;
    }

    public abstract boolean canConsoleUseCommand();

    public boolean canCommandBlockUseCommand(TileEntityCommandBlock block) {
        return this.canConsoleUseCommand();
    }

    public void register() {
        if (this.getPermissionNode() != null && this.getDefaultPermission() != null) {
            CommandHandlerForge.registerCommand((ICommand)this, this.getPermissionNode(), this.getDefaultPermission());
        } else {
            ((CommandHandler)MinecraftServer.func_71276_C().func_71187_D()).func_71560_a((ICommand)this);
        }
    }

    public abstract String getPermissionNode();

    public boolean checkCommandPermission(ICommandSender sender) {
        if (this.getPermissionNode() == null || this.getPermissionNode().isEmpty()) {
            return true;
        }
        return PermissionsManager.checkPermission(new PermissionContext().setCommandSender(sender).setCommand((ICommand)this), this.getPermissionNode());
    }

    public abstract PermissionsManager.RegisteredPermValue getDefaultPermission();

    public static List<String> getListOfStringsMatchingLastWord(String arg, Collection<String> possibleMatches) {
        ArrayList<String> arraylist = new ArrayList<String>();
        for (String s2 : possibleMatches) {
            if (!ForgeEssentialsCommandBase.func_71523_a((String)arg, (String)s2)) continue;
            arraylist.add(s2);
        }
        return arraylist;
    }

    public static List<String> getListOfStringsMatchingLastWord(String[] args, Collection<String> possibleMatches) {
        return ForgeEssentialsCommandBase.getListOfStringsMatchingLastWord(args[args.length - 1], possibleMatches);
    }

    public static List<String> getListOfStringsMatchingLastWord(String arg, String ... possibleMatches) {
        ArrayList<String> arraylist = new ArrayList<String>();
        for (String s2 : possibleMatches) {
            if (!ForgeEssentialsCommandBase.func_71523_a((String)arg, (String)s2)) continue;
            arraylist.add(s2);
        }
        return arraylist;
    }

    public static List<String> getListOfStringsMatchingLastWord(String[] args, String ... possibleMatches) {
        return ForgeEssentialsCommandBase.getListOfStringsMatchingLastWord(args[args.length - 1], possibleMatches);
    }

    public static List<String> completePlayername(String arg) {
        ArrayList<String> arraylist = new ArrayList<String>();
        for (UserIdent s2 : APIRegistry.perms.getServerZone().getKnownPlayers()) {
            if (!ForgeEssentialsCommandBase.func_71523_a((String)arg, (String)s2.getUsernameOrUUID())) continue;
            arraylist.add(s2.getUsernameOrUUID());
        }
        return arraylist;
    }

    public int compareTo(Object o) {
        if (o instanceof ICommand) {
            return this.compareTo((ICommand)o);
        }
        return 0;
    }

    public static int parseInt(ICommandSender sender, String string, int relativeStart) {
        if (string.startsWith("~")) {
            string = string.substring(1);
            return relativeStart + ForgeEssentialsCommandBase.func_71526_a((ICommandSender)sender, (String)string);
        }
        return ForgeEssentialsCommandBase.func_71526_a((ICommandSender)sender, (String)string);
    }

    public static double parseDouble(ICommandSender sender, String string, double relativeStart) {
        if (string.startsWith("~")) {
            string = string.substring(1);
            return relativeStart + (double)ForgeEssentialsCommandBase.func_71526_a((ICommandSender)sender, (String)string);
        }
        return ForgeEssentialsCommandBase.func_71526_a((ICommandSender)sender, (String)string);
    }
}

