/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.core.commands;

import com.forgeessentials.commons.VersionUtils;
import com.forgeessentials.core.commands.ForgeEssentialsCommandBase;
import com.forgeessentials.core.moduleLauncher.ModuleLauncher;
import com.forgeessentials.core.preloader.FEPreLoader;
import com.forgeessentials.util.OutputHandler;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.permissions.PermissionsManager;

public class CommandFEInfo
extends ForgeEssentialsCommandBase {
    public static final String[] options = new String[]{"debug", "reload", "modules", "about"};

    public String func_71517_b() {
        return "feinfo";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/feinfo";
    }

    @Override
    public boolean canConsoleUseCommand() {
        return true;
    }

    @Override
    public String getPermissionNode() {
        return "fe.core.info";
    }

    @Override
    public void func_71515_b(ICommandSender sender, String[] args) {
        if (args.length == 0) {
            OutputHandler.chatNotification(sender, "/feinfo reload Reloads all configs.");
            OutputHandler.chatNotification(sender, "/feinfo modules Prints a list of loaded FE modules");
            OutputHandler.chatNotification(sender, "/feinfo about About ForgeEssentials");
        } else if (args[0].equalsIgnoreCase("reload")) {
            OutputHandler.chatNotification(sender, "Reloading ForgeEssentials configs. May not work for all settings!");
            OutputHandler.chatNotification(sender, EnumChatFormatting.RED + "This is experimental!");
            ModuleLauncher.instance.reloadConfigs(sender);
            OutputHandler.chatNotification(sender, "Done!");
        } else if (args[0].equalsIgnoreCase("modules")) {
            StringBuilder buff = new StringBuilder();
            String sep = "";
            for (String str : ModuleLauncher.getModuleList()) {
                buff.append(sep);
                buff.append(str);
                sep = ", ";
            }
            OutputHandler.chatNotification(sender, "Currently loaded modules: " + buff.toString());
        } else if (args[0].equalsIgnoreCase("about")) {
            OutputHandler.chatNotification(sender, "You are currently running ForgeEssentials version 1.4.0-beta5");
            OutputHandler.chatNotification(sender, "Build information: Build number is: " + VersionUtils.getBuildNumber(FEPreLoader.jarLocation) + ", build hash is: " + VersionUtils.getBuildHash(FEPreLoader.jarLocation));
            OutputHandler.chatNotification(sender, "Please refer to https://github.com/ForgeEssentials/ForgeEssentialsMain/wiki/Team-Information if you would like more information about the FE developers.");
        }
    }

    @Override
    public PermissionsManager.RegisteredPermValue getDefaultPermission() {
        return PermissionsManager.RegisteredPermValue.OP;
    }

    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            return CommandFEInfo.func_71530_a((String[])args, (String[])options);
        }
        return null;
    }
}

