/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.core;

import com.forgeessentials.api.APIRegistry;
import com.forgeessentials.commons.VersionUtils;
import com.forgeessentials.compat.CompatReiMinimap;
import com.forgeessentials.core.commands.CommandFEDebug;
import com.forgeessentials.core.commands.CommandFEInfo;
import com.forgeessentials.core.commands.HelpFixer;
import com.forgeessentials.core.environment.CommandSetChecker;
import com.forgeessentials.core.environment.Environment;
import com.forgeessentials.core.misc.BlockModListFile;
import com.forgeessentials.core.misc.TeleportHelper;
import com.forgeessentials.core.misc.TickTaskHandler;
import com.forgeessentials.core.moduleLauncher.ModuleLauncher;
import com.forgeessentials.core.moduleLauncher.config.ConfigManager;
import com.forgeessentials.core.moduleLauncher.config.IConfigLoader;
import com.forgeessentials.core.network.S0PacketHandshake;
import com.forgeessentials.core.network.S1PacketSelectionUpdate;
import com.forgeessentials.core.preloader.FEPreLoader;
import com.forgeessentials.data.v2.DataManager;
import com.forgeessentials.util.FEChunkLoader;
import com.forgeessentials.util.FunctionHelper;
import com.forgeessentials.util.MiscEventHandler;
import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.util.PlayerInfo;
import com.forgeessentials.util.events.FEModuleEvent;
import com.forgeessentials.util.events.ForgeEssentialsEventFactory;
import com.forgeessentials.util.questioner.Questioner;
import com.forgeessentials.util.selections.CommandDeselect;
import com.forgeessentials.util.selections.CommandExpand;
import com.forgeessentials.util.selections.CommandExpandY;
import com.forgeessentials.util.selections.CommandPos;
import com.forgeessentials.util.selections.CommandWand;
import com.forgeessentials.util.selections.SelectionEventHandler;
import com.forgeessentials.util.tasks.TaskRegistry;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppedEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.permissions.PermissionsManager;

@Mod(modid="ForgeEssentials", name="Forge Essentials", version="1.4.0-beta5", acceptableRemoteVersions="*", dependencies="required-after:Forge@[10.13.2.1258,);after:WorldEdit")
public class ForgeEssentials
extends IConfigLoader.ConfigLoaderBase {
    public static final String CONFIG_CAT = "Core";
    public static final String CONFIG_CAT_MISC = "Core.Misc";
    public static final String CONFIG_CAT_MODULES = "Core.Modules";
    @Mod.Instance(value="ForgeEssentials")
    public static ForgeEssentials instance;
    private File FEDIR;
    private ConfigManager configManager;
    private boolean debugMode = false;
    public static boolean versionCheck;
    public static boolean preload;
    public static String modlistLocation;
    public static boolean mcstats;
    public ModuleLauncher moduleLauncher;
    private TaskRegistry tasks;
    private SelectionEventHandler wandHandler;
    private MiscEventHandler miscEventHandler;
    private ForgeEssentialsEventFactory factory;
    private TeleportHelper teleportHelper;
    private TickTaskHandler tickTaskHandler;
    private Questioner questioner;

    public ForgeEssentials() {
        Environment.check();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        this.FEDIR = new File(FunctionHelper.getBaseDir(), "/ForgeEssentials");
        OutputHandler.felog.info("Initializing ForgeEssentials version 1.4.0-beta5 (configDir = " + this.FEDIR.getAbsolutePath() + ")");
        OutputHandler.felog.info("Build information: Build number is: " + VersionUtils.getBuildNumber(FEPreLoader.jarLocation) + ", build hash is: " + VersionUtils.getBuildHash(FEPreLoader.jarLocation));
        this.configManager = new ConfigManager(this.FEDIR, "main");
        this.configManager.registerLoader(this.configManager.getMainConfigName(), this);
        this.configManager.registerLoader(this.configManager.getMainConfigName(), new OutputHandler());
        this.tasks = new TaskRegistry();
        FunctionHelper.netHandler = NetworkRegistry.INSTANCE.newSimpleChannel("forgeessentials");
        FunctionHelper.netHandler.registerMessage(S0PacketHandshake.class, S0PacketHandshake.class, 0, Side.SERVER);
        FunctionHelper.netHandler.registerMessage(S1PacketSelectionUpdate.class, S1PacketSelectionUpdate.class, 1, Side.CLIENT);
        this.miscEventHandler = new MiscEventHandler();
        this.moduleLauncher = new ModuleLauncher();
        this.moduleLauncher.preLoad(e);
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent e) {
        this.factory = new ForgeEssentialsEventFactory();
        this.wandHandler = new SelectionEventHandler();
        this.teleportHelper = new TeleportHelper();
        this.tickTaskHandler = new TickTaskHandler();
        FunctionHelper.FE_INTERNAL_EVENTBUS.register((Object)new CompatReiMinimap());
        FunctionHelper.FE_INTERNAL_EVENTBUS.post((Event)new FEModuleEvent.FEModuleInitEvent(e));
    }

    @Mod.EventHandler
    public void postLoad(FMLPostInitializationEvent e) {
        FunctionHelper.FE_INTERNAL_EVENTBUS.post((Event)new FEModuleEvent.FEModulePostInitEvent(e));
    }

    @Mod.EventHandler
    public void serverPreInit(FMLServerAboutToStartEvent e) {
        this.questioner = new Questioner();
        DataManager.setInstance(new DataManager(new File(FunctionHelper.getWorldPath(), "FEData/json")));
        FunctionHelper.FE_INTERNAL_EVENTBUS.post((Event)new FEModuleEvent.FEModuleServerPreInitEvent(e));
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent e) {
        BlockModListFile.makeModList();
        BlockModListFile.dumpFMLRegistries();
        e.registerServerCommand((ICommand)new HelpFixer());
        new CommandFEInfo().register();
        new CommandFEDebug().register();
        if (!ModuleLauncher.getModuleList().contains("WEIntegrationTools")) {
            new CommandPos(1).register();
            new CommandPos(2).register();
            new CommandWand().register();
            new CommandDeselect().register();
            new CommandExpand().register();
            new CommandExpandY().register();
        }
        this.tasks.onServerStart();
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)this, (ForgeChunkManager.LoadingCallback)new FEChunkLoader());
        FunctionHelper.FE_INTERNAL_EVENTBUS.post((Event)new FEModuleEvent.FEModuleServerInitEvent(e));
        this.registerPermissions();
    }

    protected void registerPermissions() {
        APIRegistry.perms.registerPermissionProperty("fe.teleport.cooldown", "5", "Allow bypassing teleport cooldown");
        APIRegistry.perms.registerPermissionProperty("fe.teleport.warmup", "3", "Allow bypassing teleport warmup");
        APIRegistry.perms.registerPermissionPropertyOp("fe.teleport.cooldown", "0");
        APIRegistry.perms.registerPermissionPropertyOp("fe.teleport.warmup", "0");
        APIRegistry.perms.registerPermission("fe.teleport.from", PermissionsManager.RegisteredPermValue.TRUE, "Allow bypassing teleport cooldown");
        APIRegistry.perms.registerPermission("fe.teleport.to", PermissionsManager.RegisteredPermValue.TRUE, "Allow bypassing teleport warmup");
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent e) {
        CommandSetChecker.remove();
        FunctionHelper.FE_INTERNAL_EVENTBUS.post((Event)new FEModuleEvent.FEModuleServerPostInitEvent(e));
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent e) {
        this.tasks.onServerStop();
        PlayerInfo.saveAll();
        PlayerInfo.clear();
        FunctionHelper.FE_INTERNAL_EVENTBUS.post((Event)new FEModuleEvent.FEModuleServerStopEvent(e));
    }

    @Mod.EventHandler
    public void serverStopped(FMLServerStoppedEvent e) {
        FunctionHelper.FE_INTERNAL_EVENTBUS.post((Event)new FEModuleEvent.FEModuleServerStoppedEvent(e));
    }

    @Override
    public void load(Configuration config, boolean isReload) {
        config.addCustomCategoryComment(CONFIG_CAT, "Configure ForgeEssentials Core.");
        config.addCustomCategoryComment(CONFIG_CAT_MODULES, "Enable/disable modules here.");
        versionCheck = config.get(CONFIG_CAT, "versionCheck", true, "Check for newer versions of ForgeEssentials on load?").getBoolean(true);
        this.configManager.setUseCanonicalConfig(config.get(CONFIG_CAT, "canonicalConfigs", false, "For modules that support it, place their configs in this file.").getBoolean(false));
        modlistLocation = config.get(CONFIG_CAT, "modlistLocation", "modlist.txt", "Specify the file where the modlist will be written to. This path is relative to the ForgeEssentials folder.").getString();
        this.debugMode = config.get(CONFIG_CAT, "debug", false, "Activates developer debug mode. Spams your FML logs.").getBoolean(false);
        CommandSetChecker.removeDuplicateCommands = config.get(CONFIG_CAT, "removeDuplicateCommands", true, "Remove commands from the list if they already exist outside of FE.").getBoolean(true);
        PlayerInfo.persistSelections = config.get(CONFIG_CAT, "persistSelections", false, "Switch to true if you want selections to persist between user sessions. Has no effect when WEIntegrationTools is installed.").getBoolean(false);
        MiscEventHandler.MajoritySleep = config.get(CONFIG_CAT_MISC, "MajoritySleep", true, "If +50% of players sleep, make it day.").getBoolean(true);
    }

    public static ConfigManager getConfigManager() {
        return ForgeEssentials.instance.configManager;
    }

    public static File getFEDirectory() {
        return ForgeEssentials.instance.FEDIR;
    }

    public static boolean isDebugMode() {
        return ForgeEssentials.instance.debugMode;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    static {
        versionCheck = true;
    }
}

