/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.commons.selections;

import com.forgeessentials.commons.IReconstructData;
import com.forgeessentials.commons.SaveableObject;
import com.forgeessentials.commons.selections.Point;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.entity.Entity;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

@SaveableObject(SaveInline=true)
public class WorldPoint
extends Point {
    private static final long serialVersionUID = 5462406378573144189L;
    @SaveableObject.SaveableField
    protected int dim;
    private static final Pattern fromStringPattern = Pattern.compile("\\s*\\[\\s*(-?\\d+)\\s*,\\s*(-?\\d+)\\s*,\\s*(-?\\d+)\\s*,\\s*dim\\s*=\\s*(-?\\d+)\\s*\\]\\s*");

    public static long getSerialversionuid() {
        return 5462406378573144189L;
    }

    public WorldPoint(int dimension, int x, int y, int z) {
        super(x, y, z);
        this.dim = dimension;
    }

    public WorldPoint(World world, int x, int y, int z) {
        super(x, y, z);
        this.dim = world.field_73011_w.field_76574_g;
    }

    public WorldPoint(Entity entity) {
        super(entity);
        this.dim = entity.field_71093_bK;
    }

    public WorldPoint(int dim, Vec3 vector) {
        super(vector);
        this.dim = dim;
    }

    public int getDimension() {
        return this.dim;
    }

    public void setDimension(int dim) {
        this.dim = dim;
    }

    @Override
    public int compareTo(WorldPoint p) {
        int diff = this.dim - p.dim;
        if (diff == 0) {
            diff = super.compareTo(p);
        }
        return diff;
    }

    public boolean equals(WorldPoint p) {
        return this.dim == p.dim && super.equals(p);
    }

    public WorldPoint copy(WorldPoint p) {
        return new WorldPoint(p.dim, p.getX(), p.getY(), p.getZ());
    }

    @SaveableObject.Reconstructor
    public static WorldPoint reconstruct(IReconstructData tag) {
        int x = (Integer)tag.getFieldValue("x");
        int y = (Integer)tag.getFieldValue("y");
        int z = (Integer)tag.getFieldValue("z");
        int dim = (Integer)tag.getFieldValue("dim");
        return new WorldPoint(dim, x, y, z);
    }

    @SaveableObject.UniqueLoadingKey
    private String getLoadingField() {
        return "WorldPoint" + this;
    }

    @Override
    public String toString() {
        return "[" + this.x + ", " + this.y + ", " + this.z + ", dim=" + this.dim + "]";
    }

    public static WorldPoint fromString(String value) {
        Matcher m = fromStringPattern.matcher(value);
        if (m.matches()) {
            try {
                return new WorldPoint(Integer.parseInt(m.group(4)), Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2)), Integer.parseInt(m.group(3)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }
}

