/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.commons.selections;

import com.forgeessentials.commons.SaveableObject;
import com.forgeessentials.commons.selections.AreaBase;
import com.forgeessentials.commons.selections.Point;
import com.forgeessentials.commons.selections.WorldPoint;
import net.minecraft.world.World;

public class WorldArea
extends AreaBase {
    @SaveableObject.SaveableField
    protected int dim;

    public WorldArea(World world, Point start, Point end) {
        super(start, end);
        this.dim = world.field_73011_w.field_76574_g;
    }

    public WorldArea(int dim, Point start, Point end) {
        super(start, end);
        this.dim = dim;
    }

    public WorldArea(int dim, AreaBase area) {
        super(area.getHighPoint(), area.getLowPoint());
        this.dim = dim;
    }

    public WorldArea(World world, AreaBase area) {
        super(area.getHighPoint(), area.getLowPoint());
        this.dim = world.field_73011_w.field_76574_g;
    }

    public int getDimension() {
        return this.dim;
    }

    public void setDimension(int dimensionId) {
        this.dim = dimensionId;
    }

    public boolean contains(WorldPoint point) {
        if (point.dim == this.dim) {
            return super.contains(point);
        }
        return false;
    }

    public boolean contains(WorldArea area) {
        if (area.dim == this.dim) {
            return super.contains(area);
        }
        return false;
    }

    public boolean intersectsWith(WorldArea area) {
        if (area.dim == this.dim) {
            return super.intersectsWith(area);
        }
        return false;
    }

    public AreaBase getIntersection(WorldArea area) {
        if (area.dim == this.dim) {
            return super.getIntersection(area);
        }
        return null;
    }

    public boolean makesCuboidWith(WorldArea area) {
        if (area.dim == this.dim) {
            return super.makesCuboidWith(area);
        }
        return false;
    }

    @SaveableObject.UniqueLoadingKey
    private String getLoadingField() {
        return "WorldArea" + this;
    }

    @Override
    public String toString() {
        return " { " + this.dim + " , " + this.getHighPoint().toString() + " , " + this.getLowPoint().toString() + " }";
    }
}

