/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.commons.selections;

import com.forgeessentials.commons.IReconstructData;
import com.forgeessentials.commons.SaveableObject;
import com.forgeessentials.commons.selections.Point;
import com.forgeessentials.commons.selections.WorldPoint;
import net.minecraft.entity.Entity;
import net.minecraft.util.Vec3;

@SaveableObject(SaveInline=true)
public class WarpPoint {
    @SaveableObject.SaveableField
    protected int dim;
    @SaveableObject.SaveableField
    protected float pitch;
    @SaveableObject.SaveableField
    protected float yaw;
    @SaveableObject.SaveableField
    protected double xd;
    @SaveableObject.SaveableField
    protected double yd;
    @SaveableObject.SaveableField
    protected double zd;

    public WarpPoint(int dimension, double x, double y, double z, float playerPitch, float playerYaw) {
        this.dim = dimension;
        this.xd = x;
        this.yd = y;
        this.zd = z;
        this.pitch = playerPitch;
        this.yaw = playerYaw;
    }

    public WarpPoint(Point p, int dimension, float playerPitch, float playerYaw) {
        this(dimension, p.getX(), p.getY(), p.getZ(), playerPitch, playerYaw);
    }

    public WarpPoint(WorldPoint p, float playerPitch, float playerYaw) {
        this(p.getDimension(), p.getX(), p.getY(), p.getZ(), playerPitch, playerYaw);
    }

    public WarpPoint(Entity sender) {
        this.dim = sender.field_71093_bK;
        this.xd = sender.field_70165_t;
        this.yd = sender.field_70163_u;
        this.zd = sender.field_70161_v;
        this.pitch = sender.field_70125_A;
        this.yaw = sender.field_70177_z;
    }

    public int compareTo(WarpPoint point) {
        if (this.equals(point)) {
            return 0;
        }
        int positives = 0;
        int negatives = 0;
        if (this.xd > point.xd) {
            ++positives;
        } else {
            ++negatives;
        }
        if (this.yd > point.yd) {
            ++positives;
        } else {
            ++negatives;
        }
        if (this.zd > point.zd) {
            ++positives;
        } else {
            ++negatives;
        }
        if (positives > negatives) {
            return 1;
        }
        if (negatives > positives) {
            return -1;
        }
        return (int)(this.xd - point.xd + (this.yd - point.yd) + (this.zd - point.zd));
    }

    public static WarpPoint copy(WarpPoint point) {
        return new WarpPoint(point.dim, point.xd, point.yd, point.zd, point.pitch, point.yaw);
    }

    public void validate() {
        if (this.yd < 0.0) {
            this.yd = 0.0;
        }
    }

    public double getDistanceTo(WarpPoint point) {
        return Math.sqrt((this.xd - point.xd) * (this.xd - point.xd) + (this.yd - point.yd) * (this.yd - point.yd) + (this.zd - point.zd) * (this.zd - point.zd));
    }

    public double getDistanceTo(Entity e) {
        return Math.sqrt((this.xd - e.field_70165_t) * (this.xd - e.field_70165_t) + (this.yd - e.field_70163_u) * (this.yd - e.field_70163_u) + (this.zd - e.field_70161_v) * (this.zd - e.field_70161_v));
    }

    @SaveableObject.Reconstructor
    public static WarpPoint reconstruct(IReconstructData tag) {
        double x = (Double)tag.getFieldValue("xd");
        double y = (Double)tag.getFieldValue("yd");
        double z = (Double)tag.getFieldValue("zd");
        int dim = (Integer)tag.getFieldValue("dim");
        float pitch = ((Float)tag.getFieldValue("pitch")).floatValue();
        float yaw = ((Float)tag.getFieldValue("yaw")).floatValue();
        return new WarpPoint(dim, x, y, z, pitch, yaw);
    }

    @SaveableObject.UniqueLoadingKey
    private String getLoadingField() {
        return "WarpPoint" + this;
    }

    public String toString() {
        return "WarpPoint[" + this.dim + "," + this.xd + "," + this.yd + "," + this.zd + "," + this.pitch + "," + this.yaw + "]";
    }

    public Vec3 toVec3() {
        return Vec3.func_72443_a((double)this.xd, (double)this.yd, (double)this.zd);
    }

    public int getDimension() {
        return this.dim;
    }

    public double getX() {
        return this.xd;
    }

    public double getY() {
        return this.yd;
    }

    public double getZ() {
        return this.zd;
    }

    public void setX(double value) {
        this.xd = value;
    }

    public void setY(double value) {
        this.yd = value;
    }

    public void setZ(double value) {
        this.zd = value;
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getYaw() {
        return this.yaw;
    }

    public void setPitch(float value) {
        this.pitch = value;
    }

    public void setYaw(float value) {
        this.yaw = value;
    }

    public int getBlockX() {
        return (int)this.xd;
    }

    public int getBlockY() {
        return (int)this.yd;
    }

    public int getBlockZ() {
        return (int)this.zd;
    }

    public WorldPoint toWorldPoint() {
        return new WorldPoint(this.dim, (int)Math.floor(this.xd), (int)Math.floor(this.yd), (int)Math.floor(this.zd));
    }

    public boolean equals(Object point) {
        return this.toString().equals(point.toString());
    }
}

