/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.commons.selections;

import com.forgeessentials.commons.IReconstructData;
import com.forgeessentials.commons.SaveableObject;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.entity.Entity;
import net.minecraft.util.Vec3;

@SaveableObject(SaveInline=true)
public class Point
implements Serializable,
Comparable<Point> {
    private static final long serialVersionUID = 9058731447466825626L;
    @SaveableObject.SaveableField
    public int x;
    @SaveableObject.SaveableField
    public int y;
    @SaveableObject.SaveableField
    public int z;
    private static final Pattern pattern = Pattern.compile("\\s*\\[\\s*(-?\\d+)\\s*,\\s*(-?\\d+)\\s*,\\s*(-?\\d+)\\s*\\]\\s*");

    public Point(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Point(double x, double y, double z) {
        this.x = (int)x;
        this.y = (int)y;
        this.z = (int)z;
    }

    public Point(Entity entity) {
        this.x = (int)Math.floor(entity.field_70165_t);
        this.y = (int)Math.floor(entity.field_70163_u);
        this.z = (int)Math.floor(entity.field_70161_v);
    }

    public Point(Vec3 vector) {
        this((int)vector.field_72450_a, (int)vector.field_72448_b, (int)vector.field_72449_c);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setZ(int z) {
        this.z = z;
    }

    @Override
    public int compareTo(Point point) {
        if (this.equals(point)) {
            return 0;
        }
        int positives = 0;
        int negatives = 0;
        if (this.x > point.x) {
            ++positives;
        } else {
            ++negatives;
        }
        if (this.y > point.y) {
            ++positives;
        } else {
            ++negatives;
        }
        if (this.z > point.z) {
            ++positives;
        } else {
            ++negatives;
        }
        if (positives > negatives) {
            return 1;
        }
        if (negatives > positives) {
            return -1;
        }
        return this.x - point.x + this.y - point.y + this.z - point.z;
    }

    public boolean equals(Object object) {
        if (object instanceof Point) {
            Point p = (Point)object;
            if (this.x == p.x && this.y == p.y && this.z == p.z) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int h = 11 + this.x;
        h = h * 29 + this.y;
        h = h * 29 + this.z;
        return h;
    }

    public double getDistanceTo(Point point) {
        return Math.sqrt((this.x - point.x) * (this.x - point.x) + (this.y - point.y) * (this.y - point.y) + (this.z - point.z) * (this.z - point.z));
    }

    public boolean alignsWith(Point p) {
        return this.x == p.x || this.y == p.y || this.z == p.z;
    }

    public boolean isGreaterEqualThan(Point p) {
        return this.x >= p.x && this.y >= p.y && this.z >= p.z;
    }

    public boolean isLessEqualThan(Point p) {
        return this.x <= p.x && this.y <= p.y && this.z <= p.z;
    }

    public static Point copy(Point point) {
        return new Point(point.x, point.y, point.z);
    }

    public void validate() {
        if (this.y < 0) {
            this.y = 0;
        }
    }

    @SaveableObject.Reconstructor
    public static Point reconstruct(IReconstructData tag) {
        int x = (Integer)tag.getFieldValue("x");
        int y = (Integer)tag.getFieldValue("y");
        int z = (Integer)tag.getFieldValue("z");
        return new Point(x, y, z);
    }

    @SaveableObject.UniqueLoadingKey
    private String getLoadingField() {
        return this.toString();
    }

    public String toString() {
        return "[" + this.x + ", " + this.y + ", " + this.z + "]";
    }

    public static Point fromString(String value) {
        Matcher match = pattern.matcher(value);
        if (!match.matches()) {
            return null;
        }
        return new Point(Integer.parseInt(match.group(1)), Integer.parseInt(match.group(2)), Integer.parseInt(match.group(3)));
    }

    public Vec3 toVec3() {
        return Vec3.func_72443_a((double)this.x, (double)this.y, (double)this.z);
    }
}

