/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.commons.selections;

import com.forgeessentials.commons.selections.AreaBase;
import com.forgeessentials.commons.selections.Point;

public enum AreaShape {
    BOX,
    ELLIPSOID,
    CYLINDER;


    public boolean contains(AreaBase area, Point point) {
        if (!area.contains(point)) {
            return false;
        }
        if (this == BOX) {
            return true;
        }
        float dx = (float)(point.x - area.low.x) / (float)(area.high.x - area.low.x) * 2.0f - 1.0f;
        float dy = (float)(point.y - area.low.y) / (float)(area.high.y - area.low.y) * 2.0f - 1.0f;
        float dz = (float)(point.z - area.low.z) / (float)(area.high.z - area.low.z) * 2.0f - 1.0f;
        switch (this) {
            case ELLIPSOID: {
                return dx * dx + dy * dy + dz * dz <= 1.0f;
            }
            case CYLINDER: {
                return dx * dx + dz * dz <= 1.0f;
            }
        }
        return true;
    }

    public boolean contains(AreaBase area, AreaBase otherArea) {
        if (this == BOX) {
            return area.contains(otherArea);
        }
        Point p1 = new Point(otherArea.low.x, otherArea.low.y, otherArea.low.z);
        Point p2 = new Point(otherArea.low.x, otherArea.low.y, otherArea.high.z);
        Point p3 = new Point(otherArea.low.x, otherArea.high.y, otherArea.low.z);
        Point p4 = new Point(otherArea.low.x, otherArea.high.y, otherArea.high.z);
        Point p5 = new Point(otherArea.high.x, otherArea.low.y, otherArea.low.z);
        Point p6 = new Point(otherArea.high.x, otherArea.low.y, otherArea.high.z);
        Point p7 = new Point(otherArea.high.x, otherArea.high.y, otherArea.low.z);
        Point p8 = new Point(otherArea.high.x, otherArea.high.y, otherArea.high.z);
        return this.contains(area, p1) && this.contains(area, p2) && this.contains(area, p3) && this.contains(area, p4) && this.contains(area, p5) && this.contains(area, p6) && this.contains(area, p7) && this.contains(area, p8);
    }

    public static AreaShape getByName(String name) {
        if (name == null) {
            return null;
        }
        try {
            return AreaShape.valueOf(name.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static String[] valueNames() {
        AreaShape[] values = AreaShape.values();
        String[] names = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            names[i] = values[i].toString();
        }
        return names;
    }
}

