/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.commands.util;

import com.forgeessentials.commons.IReconstructData;
import com.forgeessentials.commons.SaveableObject;

@SaveableObject
public class WeatherTimeData {
    public static final int dayTimeStart = 1;
    public static final int dayTimeEnd = 11;
    public static final int nightTimeStart = 14;
    public static final int nightTimeEnd = 22;
    @SaveableObject.UniqueLoadingKey
    @SaveableObject.SaveableField
    public int dimID;
    @SaveableObject.SaveableField
    public boolean weatherSpecified;
    @SaveableObject.SaveableField
    public boolean rain;
    @SaveableObject.SaveableField
    public boolean storm;
    @SaveableObject.SaveableField
    public boolean timeSpecified;
    @SaveableObject.SaveableField
    public boolean day;
    @SaveableObject.SaveableField
    public boolean timeFreeze;
    @SaveableObject.SaveableField
    public long freezeTime;

    public WeatherTimeData(int dimID) {
        this.dimID = dimID;
        this.weatherSpecified = false;
        this.timeSpecified = false;
        this.timeFreeze = false;
        this.storm = false;
        this.rain = false;
        this.day = true;
    }

    @SaveableObject.Reconstructor
    private static WeatherTimeData reconstruct(IReconstructData tag) {
        WeatherTimeData data = new WeatherTimeData(Integer.parseInt(tag.getUniqueKey()));
        data.weatherSpecified = tag.getFieldValue("weatherSpecified").toString().equals(true);
        data.rain = tag.getFieldValue("rain").toString().equals(true);
        data.storm = tag.getFieldValue("storm").toString().equals(true);
        data.timeSpecified = tag.getFieldValue("timeSpecified").toString().equals(true);
        data.day = tag.getFieldValue("day").toString().equals(true);
        data.timeFreeze = tag.getFieldValue("timeFreeze").toString().equals(true);
        return data;
    }
}

