/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.commands.util;

import com.forgeessentials.commons.selections.Point;
import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.util.tasks.ITickTask;
import com.forgeessentials.util.tasks.TaskRegistry;
import cpw.mods.fml.common.registry.GameData;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class TickTaskBlockFinder
implements ITickTask {
    private World world;
    private EntityPlayer player;
    private Block block;
    private String blockName;
    private int meta;
    private int targetRange;
    private int targetAmount;
    private int centerX;
    private int centerZ;
    private ItemStack stack;
    private int speed;
    private int di = 1;
    private int dj = 0;
    private int segment_length = 1;
    private int i = 0;
    private int j = 0;
    private int segment_passed = 0;
    ArrayList<Point> results = new ArrayList();

    public TickTaskBlockFinder(EntityPlayer player, String id, int meta, int range, int amount, int speed) {
        this.player = player;
        this.meta = meta;
        this.targetRange = range;
        this.targetAmount = amount;
        this.speed = speed;
        this.centerX = (int)player.field_70165_t;
        this.centerZ = (int)player.field_70161_v;
        this.world = player.field_70170_p;
        this.block = (Block)GameData.getBlockRegistry().func_82594_a(id);
        if (this.block == null) {
            try {
                int intId = Integer.parseInt(id);
                this.block = (Block)GameData.getBlockRegistry().getRaw(intId);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (this.block == null) {
            this.msg("Error: " + id + ":" + meta + " unkown.");
            return;
        }
        this.stack = new ItemStack(this.block, 1, meta);
        this.blockName = this.stack.func_77973_b() != null ? this.stack.func_82833_r() : GameData.getBlockRegistry().func_148750_c((Object)this.block);
        this.msg("Start the hunt for " + this.blockName);
        TaskRegistry.registerTask(this);
    }

    @Override
    public void tick() {
        int speedcounter = 0;
        while (!this.isComplete() && speedcounter < this.speed) {
            ++speedcounter;
            for (int y = this.world.func_72940_L(); !this.isComplete() && y >= 0; --y) {
                Block b = this.world.func_147439_a(this.centerX + this.i, y, this.centerZ + this.j);
                if (!b.equals(this.block) || this.meta != -1 && this.world.func_72805_g(this.centerX + this.i, y, this.centerZ + this.j) != this.meta) continue;
                Point p = new Point(this.centerX + this.i, y, this.centerZ + this.j);
                this.results.add(p);
                this.msg("Found " + this.blockName + " at " + p.getX() + ";" + p.getY() + ";" + p.getZ());
            }
            this.i += this.di;
            this.j += this.dj;
            ++this.segment_passed;
            if (this.segment_passed != this.segment_length) continue;
            this.segment_passed = 0;
            int buffer = this.di;
            this.di = -this.dj;
            this.dj = buffer;
            if (this.dj != 0) continue;
            ++this.segment_length;
        }
    }

    private void msg(String string) {
        OutputHandler.chatNotification((ICommandSender)this.player, string);
    }

    @Override
    public void onComplete() {
        if (this.results.isEmpty()) {
            this.msg("Found nothing withing target range.");
        } else {
            this.msg("Stoped looking for " + this.blockName);
        }
    }

    @Override
    public boolean isComplete() {
        return this.results.size() >= this.targetAmount || this.segment_length > this.targetRange;
    }

    @Override
    public boolean editsBlocks() {
        return false;
    }
}

