/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.commands.util;

import com.forgeessentials.api.EnumMobType;
import com.google.common.collect.HashMultimap;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.EntityTameable;

public class MobTypeRegistry {
    private static final HashMultimap<EnumMobType, String> MobTypeRegistry = HashMultimap.create();
    private static final HashMap<String, String> tameableChecks = new HashMap();

    public static final void addMob(EnumMobType type, String className) {
        MobTypeRegistry.put((Object)type, (Object)className);
    }

    public static final void addMob(EnumMobType type, String className, String tameableCheckObject) {
        tameableChecks.put(className, tameableCheckObject);
        MobTypeRegistry.put((Object)type, (Object)className);
    }

    public static Set<String> getCollectionForMobType(EnumMobType type) {
        return MobTypeRegistry.get((Object)type);
    }

    public static boolean isTamed(EntityLiving mob) {
        if (mob instanceof EntityTameable) {
            return ((EntityTameable)mob).func_70909_n();
        }
        if (MobTypeRegistry.get((Object)EnumMobType.TAMEABLE).contains(mob.getClass().getName())) {
            try {
                Class<?> c = mob.getClass();
                String obj = tameableChecks.get(c.getName());
                boolean isMethod = obj.endsWith("()");
                obj = obj.replace("()", "");
                if (isMethod) {
                    Method m = c.getDeclaredMethod(obj, new Class[0]);
                    m.setAccessible(true);
                    return (Boolean)m.invoke((Object)mob, new Object[0]);
                }
                Field f = c.getDeclaredField(obj);
                f.setAccessible(true);
                return f.getBoolean(mob);
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }
}

