/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.commands.util;

import com.forgeessentials.api.EnumMobType;
import com.forgeessentials.commands.util.MobTypeRegistry;
import com.forgeessentials.util.OutputHandler;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Set;
import net.minecraft.entity.passive.EntityTameable;

public class MobTypeLoader {
    public static void preLoad(FMLPreInitializationEvent event) {
        OutputHandler.felog.info("Discovering and loading FEMob data...");
        Set data = event.getAsmData().getAll(EnumMobType.FEMob.class.getName());
        for (ASMDataTable.ASMData asm : data) {
            Class<?> c = null;
            String className = asm.getClassName();
            try {
                c = Class.forName(className);
            }
            catch (Exception e) {
                OutputHandler.felog.info("Error trying to load " + asm.getClassName() + " as a FEMob!");
                e.printStackTrace();
                return;
            }
            EnumMobType.FEMob annot = c.getAnnotation(EnumMobType.FEMob.class);
            if (annot == null) {
                throw new IllegalArgumentException(c.getName() + " doesn't have the @FEMob annotation!");
            }
            EnumMobType type = annot.type();
            if (type != EnumMobType.TAMEABLE) {
                MobTypeRegistry.addMob(type, className);
                continue;
            }
            if (EntityTameable.class.isAssignableFrom(c)) continue;
            String isTameableName = null;
            for (Field field : c.getDeclaredFields()) {
                if (!field.isAnnotationPresent(EnumMobType.FEMob.IsTamed.class)) continue;
                if (isTameableName != null) {
                    throw new RuntimeException("Two elements in " + className + " cannot be marked @IsTamed!");
                }
                if (!field.getType().equals(Boolean.TYPE)) {
                    throw new RuntimeException(field.getName() + " in " + className + " must be of type boolean!");
                }
                if (Modifier.isStatic(field.getModifiers())) {
                    throw new RuntimeException(field.getName() + " in " + className + " cannot be static!");
                }
                isTameableName = field.getName();
            }
            for (AccessibleObject accessibleObject : c.getDeclaredMethods()) {
                if (!accessibleObject.isAnnotationPresent(EnumMobType.FEMob.IsTamed.class)) continue;
                if (isTameableName != null) {
                    throw new RuntimeException("Two elements in " + className + " cannot be marked @IsTamed!");
                }
                if (!((Method)accessibleObject).getReturnType().equals(Boolean.TYPE)) {
                    throw new RuntimeException(((Method)accessibleObject).getName() + " in " + className + " must return a boolean!");
                }
                if (((Method)accessibleObject).getParameterTypes().length > 0) {
                    throw new RuntimeException(((Method)accessibleObject).getName() + " in " + className + " must take no parameters or arguments!");
                }
                if (Modifier.isStatic(((Method)accessibleObject).getModifiers())) {
                    throw new RuntimeException(((Method)accessibleObject).getName() + " in " + className + " cannot be static!");
                }
                isTameableName = ((Method)accessibleObject).getName() + "()";
            }
            if (isTameableName == null) {
                throw new RuntimeException(className + " MUST have an elemnt marked @isTamed! Override an inhertied method even!");
            }
            MobTypeRegistry.addMob(type, className, isTameableName);
        }
    }
}

