/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.commands.util;

import com.forgeessentials.compat.CompatReiMinimap;
import com.forgeessentials.core.ForgeEssentials;
import com.forgeessentials.util.FunctionHelper;
import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.util.PlayerInfo;
import com.forgeessentials.util.UserIdent;
import cpw.mods.fml.common.FMLCommonHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;

public class LoginMessage {
    private static List<String> messageList = new ArrayList<String>();
    private static MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();

    public static void loadFile() {
        messageList.clear();
        File file = new File(ForgeEssentials.getFEDirectory(), "MOTD.txt");
        if (file.exists()) {
            try (BufferedReader br = new BufferedReader(new FileReader(file));){
                while (br.ready()) {
                    String line = br.readLine().trim();
                    if (line.startsWith("#") || line.isEmpty()) continue;
                    messageList.add(line);
                }
            }
            catch (IOException e) {
                OutputHandler.felog.info("Error reading the MOTD file.");
            }
        } else {
            try {
                file.createNewFile();
                try (PrintWriter pw = new PrintWriter(file);){
                    pw.println("# This file contains the message sent to the player on login.");
                    pw.println("# Lines starting with # are not read.");
                    pw.println("# There are several codes that can be used to format the text.");
                    pw.println("# If you want to use color, use this symbol & (ALT code 21) to indicate a color.");
                    pw.println("# Handy link: http://www.minecraftwiki.net/wiki/Formatting_codes");
                    pw.println("# Other codes:");
                    pw.println("# %playername% => The name of the player the message is send to");
                    pw.println("# %rank% => Players rank (see chat config)");
                    pw.println("# %groupPrefix% => Group prefix (see chat config)");
                    pw.println("# %groupSuffix% => Group suffix (see chat config)");
                    pw.println("# %playerPrefix% => Player prefix (see chat config)");
                    pw.println("# %playerSuffix% => Player suffix (see chat config)");
                    pw.println("# %players% => Amount of players online.");
                    pw.println("# %uptime% => Current server uptime.");
                    pw.println("# %uniqueplayers% => Amount of unique player logins.");
                    pw.println("# %time% => Local server time. All in one string.");
                    pw.println("# %hour% ; %min% ; %sec% => Local server time.");
                    pw.println("# %day% ; %month% ; %year% => Local server date.");
                    pw.println("# %online => Nice list of online players.");
                    pw.println("# ");
                    pw.println("# If you would like more codes, you can make an issue on https://github.com/ForgeEssentials/ForgeEssentialsMain/issues");
                    pw.println("");
                    pw.println("Welcome %playername%, to a server running ForgeEssentials.");
                    pw.println("There are %players% players online, and we have had %uniqueplayers% unique players.");
                    pw.println("Server time: %time%. Uptime: %uptime%");
                }
                LoginMessage.loadFile();
            }
            catch (Exception e) {
                OutputHandler.felog.info("Error reading the MOTD file.");
                e.printStackTrace();
            }
        }
    }

    public static void setMOTD(Collection<String> messages) {
        messageList.clear();
        messageList.addAll(messages);
    }

    public static void sendLoginMessage(ICommandSender sender) {
        for (int id = 0; id < messageList.size(); ++id) {
            if (id == 0) {
                if (sender instanceof EntityPlayer) {
                    OutputHandler.sendMessage(sender, CompatReiMinimap.reimotd((EntityPlayer)sender) + LoginMessage.format(messageList.get(id), sender.func_70005_c_()));
                    continue;
                }
                OutputHandler.sendMessage(sender, LoginMessage.format(messageList.get(id), sender.func_70005_c_()));
                continue;
            }
            OutputHandler.sendMessage(sender, LoginMessage.format(messageList.get(id), sender.func_70005_c_()));
        }
    }

    private static String format(String line, String playerName) {
        Calendar cal = Calendar.getInstance();
        line = FunctionHelper.formatColors(line);
        line = FunctionHelper.format(line);
        line = FunctionHelper.replaceAllIgnoreCase(line, "%players%", LoginMessage.online());
        line = FunctionHelper.replaceAllIgnoreCase(line, "%uptime%", LoginMessage.getUptime());
        line = FunctionHelper.replaceAllIgnoreCase(line, "%uniqueplayers%", LoginMessage.uniqueplayers());
        line = FunctionHelper.replaceAllIgnoreCase(line, "%online", FunctionHelper.getFormattedPlayersOnline());
        line = FunctionHelper.replaceAllIgnoreCase(line, "%time%", FunctionHelper.getCurrentTimeString());
        line = FunctionHelper.replaceAllIgnoreCase(line, "%hour%", "" + cal.get(10));
        line = FunctionHelper.replaceAllIgnoreCase(line, "%min%", "" + cal.get(12));
        line = FunctionHelper.replaceAllIgnoreCase(line, "%sec%", "" + cal.get(13));
        line = FunctionHelper.replaceAllIgnoreCase(line, "%day%", "" + cal.get(5));
        line = FunctionHelper.replaceAllIgnoreCase(line, "%month%", "" + cal.get(2));
        line = FunctionHelper.replaceAllIgnoreCase(line, "%year%", "" + cal.get(1));
        line = FunctionHelper.replaceAllIgnoreCase(line, "%playerPrefix%", FunctionHelper.formatColors(FunctionHelper.getPlayerPrefixSuffix(new UserIdent(playerName), false)).trim());
        line = FunctionHelper.replaceAllIgnoreCase(line, "%playerSuffix%", FunctionHelper.formatColors(FunctionHelper.getPlayerPrefixSuffix(new UserIdent(playerName), true)).trim());
        line = FunctionHelper.replaceAllIgnoreCase(line, "%groupPrefix%", FunctionHelper.formatColors(FunctionHelper.getPlayerGroupPrefixSuffix(new UserIdent(playerName), false)).trim());
        line = FunctionHelper.replaceAllIgnoreCase(line, "%groupSuffix%", FunctionHelper.formatColors(FunctionHelper.getPlayerGroupPrefixSuffix(new UserIdent(playerName), true)).trim());
        EntityPlayerMP player = FMLCommonHandler.instance().getSidedDelegate().getServer().func_71203_ab().func_152612_a(playerName);
        if (player != null) {
            line = FunctionHelper.replaceAllIgnoreCase(line, "%playername%", player.getDisplayName());
        }
        return line;
    }

    private static String online() {
        int online = 0;
        try {
            online = server.func_71233_x();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "" + online;
    }

    private static String uniqueplayers() {
        int logins = 0;
        try {
            logins = PlayerInfo.getPlayerInfoMap().size();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "" + logins;
    }

    public static String getUptime() {
        RuntimeMXBean rb = ManagementFactory.getRuntimeMXBean();
        int secsIn = (int)(rb.getUptime() / 1000L);
        return FunctionHelper.parseTime(secsIn);
    }
}

