/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.commands.util;

import com.forgeessentials.commands.util.CommandDataManager;
import com.forgeessentials.commons.IReconstructData;
import com.forgeessentials.commons.SaveableObject;
import com.forgeessentials.util.FunctionHelper;
import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.util.PlayerInfo;
import java.util.ArrayList;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.permissions.PermissionsManager;

@SaveableObject
public class Kit {
    @SaveableObject.UniqueLoadingKey
    @SaveableObject.SaveableField
    private String name;
    @SaveableObject.SaveableField
    private Integer cooldown;
    @SaveableObject.SaveableField
    private ItemStack[] items;
    @SaveableObject.SaveableField
    private ItemStack[] armor;

    public Kit(EntityPlayer player, String name, int cooldown) {
        int i;
        this.cooldown = cooldown;
        this.name = name;
        ArrayList<ItemStack> inventory = new ArrayList<ItemStack>();
        for (i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
            if (player.field_71071_by.field_70462_a[i] == null) continue;
            inventory.add(player.field_71071_by.field_70462_a[i]);
        }
        this.items = new ItemStack[inventory.size()];
        for (i = 0; i < inventory.size(); ++i) {
            this.items[i] = (ItemStack)inventory.get(i);
        }
        this.armor = new ItemStack[player.field_71071_by.field_70460_b.length];
        for (i = 0; i < 4; ++i) {
            if (player.field_71071_by.field_70460_b[i] == null) continue;
            this.armor[i] = player.field_71071_by.field_70460_b[i].func_77946_l();
        }
        CommandDataManager.addKit(this);
    }

    private Kit(Object name, Object cooldown, Object items, Object armor) {
        this.name = (String)name;
        this.cooldown = (Integer)cooldown;
        this.items = new ItemStack[((Object[])items).length];
        this.armor = new ItemStack[4];
        for (ItemStack is : (ItemStack[])items) {
            for (int i = 0; i < ((ItemStack[])items).length; ++i) {
                this.items[i] = is;
            }
        }
        for (ItemStack is : (ItemStack[])armor) {
            if (is == null) continue;
            int atype = 3 - ((ItemArmor)is.func_77973_b()).field_77881_a;
            this.armor[atype] = is;
        }
    }

    @SaveableObject.Reconstructor
    private static Kit reconstruct(IReconstructData tag) {
        return new Kit(tag.getFieldValue("name"), tag.getFieldValue("cooldown"), tag.getFieldValue("items"), tag.getFieldValue("armor"));
    }

    public String getName() {
        return this.name;
    }

    public Integer getCooldown() {
        return this.cooldown;
    }

    public ItemStack[] getItems() {
        return this.items;
    }

    public ItemStack[] getArmor() {
        return this.armor;
    }

    public void giveKit(EntityPlayer player) {
        if (PlayerInfo.getPlayerInfo(player.getPersistentID()).getKitCooldown().containsKey(this.getName())) {
            OutputHandler.chatWarning((ICommandSender)player, "Kit cooldown active, %c seconds to go!".replaceAll("%c", "" + FunctionHelper.parseTime(PlayerInfo.getPlayerInfo(player.getPersistentID()).getKitCooldown().get(this.getName()))));
        } else {
            if (!PermissionsManager.checkPermission(player, "fe.TickHandlerCommands.BypassKitCooldown")) {
                PlayerInfo.getPlayerInfo(player.getPersistentID()).getKitCooldown().put(this.getName(), this.getCooldown());
            }
            for (ItemStack stack : this.getItems()) {
                if (player.field_71071_by.func_70441_a(ItemStack.func_77944_b((ItemStack)stack))) {
                    System.out.println(stack.func_82833_r());
                    continue;
                }
                System.out.println("Couldn't give " + stack.func_82833_r());
            }
            for (int i = 0; i < 4; ++i) {
                if (this.getArmor()[i] == null) continue;
                ItemStack stack = this.getArmor()[i];
                if (player.field_71071_by.field_70460_b[i] == null) {
                    player.field_71071_by.field_70460_b[i] = stack;
                    continue;
                }
                player.field_71071_by.func_70441_a(ItemStack.func_77944_b((ItemStack)stack));
            }
            OutputHandler.chatConfirmation((ICommandSender)player, "Kit dropped.");
        }
    }
}

