/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.commands.util;

import com.forgeessentials.core.commands.ForgeEssentialsCommandBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntityCommandBlock;
import net.minecraftforge.common.config.Configuration;

public abstract class FEcmdModuleCommands
extends ForgeEssentialsCommandBase {
    private boolean enabledForCmdBlock = true;
    private boolean enabledForConsole = true;
    private boolean enabledForPlayer = true;
    private List<String> aliases = new ArrayList<String>();

    @Override
    public boolean func_71519_b(ICommandSender sender) {
        if (!super.func_71519_b(sender)) {
            return false;
        }
        if (sender instanceof EntityPlayer && !this.enabledForPlayer) {
            return FEcmdModuleCommands.canCommandSenderUseCommandException("This command is disabled for players");
        }
        if (sender instanceof TileEntityCommandBlock && !this.enabledForCmdBlock) {
            return FEcmdModuleCommands.canCommandSenderUseCommandException("This command is disabled for command-blocks");
        }
        if (!this.enabledForConsole) {
            return FEcmdModuleCommands.canCommandSenderUseCommandException("This command is disabled for console");
        }
        return true;
    }

    public void loadConfig(Configuration config, String category) {
        config.addCustomCategoryComment(category, this.getPermissionNode());
        for (String alias : config.get(category, "aliases", this.getDefaultAliases()).getStringList()) {
            this.aliases.add(alias);
        }
    }

    public List<String> func_71514_a() {
        return this.aliases;
    }

    public String[] getDefaultAliases() {
        return new String[0];
    }

    public void registerExtraPermissions() {
    }

    @Override
    public String getPermissionNode() {
        return "fe.commands." + this.func_71517_b();
    }

    public boolean usableByPlayer() {
        return true;
    }

    public boolean usableByCmdBlock() {
        return this.canConsoleUseCommand();
    }

    public boolean isEnabledForCmdBlock() {
        return this.enabledForCmdBlock;
    }

    public boolean isEnabledForConsole() {
        return this.enabledForConsole;
    }

    public boolean isEnabledForPlayer() {
        return this.enabledForPlayer;
    }

    public void setEnabledForCmdBlock(boolean enabledForCmdBlock) {
        this.enabledForCmdBlock = enabledForCmdBlock;
    }

    public void setEnabledForConsole(boolean enabledForConsole) {
        this.enabledForConsole = enabledForConsole;
    }

    public void setEnabledForPlayer(boolean enabledForPlayer) {
        this.enabledForPlayer = enabledForPlayer;
    }
}

