/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.commands.util;

import com.forgeessentials.commands.util.Kit;
import com.forgeessentials.commands.util.WeatherTimeData;
import com.forgeessentials.data.v2.DataManager;
import java.util.HashMap;
import java.util.Map;

public class CommandDataManager {
    public static Map<String, Kit> kits = new HashMap<String, Kit>();
    public static Map<Integer, WeatherTimeData> WTmap = new HashMap<Integer, WeatherTimeData>();

    public static void load() {
        CommandDataManager.loadKits();
        CommandDataManager.loadWT();
    }

    public static void save() {
        CommandDataManager.saveKits();
        CommandDataManager.saveWT();
    }

    public static void loadKits() {
        kits = DataManager.getInstance().loadAll(Kit.class);
    }

    public static void loadWT() {
        Map<String, WeatherTimeData> wtData = DataManager.getInstance().loadAll(WeatherTimeData.class);
        for (WeatherTimeData wt : wtData.values()) {
            WTmap.put(wt.dimID, wt);
        }
    }

    public static void saveKits() {
        for (Kit kit : kits.values()) {
            DataManager.getInstance().save(kit, kit.getName());
        }
    }

    public static void saveWT() {
        for (WeatherTimeData wt : WTmap.values()) {
            DataManager.getInstance().save(wt, Integer.toString(wt.dimID));
        }
    }

    public static void addKit(Kit kit) {
        kits.put(kit.getName(), kit);
        DataManager.getInstance().save(kit, kit.getName());
    }

    public static void removeKit(Kit kit) {
        kits.remove(kit.getName());
        DataManager.getInstance().delete(Kit.class, kit.getName());
    }
}

