/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.commands.util;

import com.forgeessentials.api.EnumMobType;
import com.forgeessentials.commands.util.MobTypeRegistry;
import com.forgeessentials.core.misc.TickTaskHandler;
import com.forgeessentials.util.OutputHandler;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.passive.EntityAmbientCreature;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import org.apache.commons.lang3.StringUtils;

public class CommandButcherTickTask
implements TickTaskHandler.TickTask {
    private ICommandSender sender;
    private ButcherMobType mobType;
    private AxisAlignedBB aabb;
    private World world;
    private int radius;
    private int maxChunkX;
    private int maxChunkZ;
    private int minChunkX;
    private int minChunkZ;
    private int killCount;
    private int tickKillCount;
    private boolean isComplete;
    private static final int MAX_TICK_KILLS = 1;

    public CommandButcherTickTask(ICommandSender sender, World world, ButcherMobType mobType, AxisAlignedBB aabb, int radius) {
        this.sender = sender;
        this.mobType = mobType;
        this.radius = radius;
        this.world = world;
        if (radius > -1) {
            this.aabb = aabb;
            this.minChunkX = MathHelper.func_76128_c((double)((aabb.field_72340_a - World.MAX_ENTITY_RADIUS) / 16.0));
            this.maxChunkX = MathHelper.func_76128_c((double)((aabb.field_72336_d + World.MAX_ENTITY_RADIUS) / 16.0));
            this.minChunkZ = MathHelper.func_76128_c((double)((aabb.field_72339_c - World.MAX_ENTITY_RADIUS) / 16.0));
            this.maxChunkZ = MathHelper.func_76128_c((double)((aabb.field_72334_f + World.MAX_ENTITY_RADIUS) / 16.0));
        }
    }

    public CommandButcherTickTask(ICommandSender sender, World world, String mobType, AxisAlignedBB aabb, int radius) {
        this(sender, world, ButcherMobType.valueOf(mobType.toUpperCase()), aabb, radius);
    }

    public static void schedule(ICommandSender sender, World world, String mobType, AxisAlignedBB aabb, int radius) {
        try {
            ButcherMobType mobT = ButcherMobType.valueOf(mobType.toUpperCase());
            TickTaskHandler.schedule(new CommandButcherTickTask(sender, world, mobT, aabb, radius));
        }
        catch (IllegalArgumentException e) {
            OutputHandler.chatError(sender, "Unknown mob type. Mob types are " + StringUtils.join((Object[])ButcherMobType.values(), (String)", "));
        }
    }

    @Override
    public void tick() {
        if (this.isComplete) {
            return;
        }
        this.tickKillCount = 0;
        if (this.radius < -1) {
            this.isComplete = true;
        } else if (this.radius == -1) {
            for (Object entity : this.world.field_72996_f) {
                if (!(entity instanceof EntityLiving)) continue;
                this.checkEntity((EntityLiving)entity);
                if (this.tickKillCount < 32) continue;
                return;
            }
            this.isComplete = true;
        } else {
            for (int chunkX = this.minChunkX; chunkX <= this.maxChunkX; ++chunkX) {
                for (int chunkZ = this.minChunkZ; chunkZ <= this.maxChunkZ; ++chunkZ) {
                    if (!this.world.func_72863_F().func_73149_a(chunkX, chunkZ)) continue;
                    LinkedList list = new LinkedList();
                    this.world.func_72964_e(chunkX, chunkZ).func_76618_a(EntityLiving.class, this.aabb, list, null);
                    for (EntityLiving entity : list) {
                        this.checkEntity(entity);
                        if (this.tickKillCount < 1) continue;
                        return;
                    }
                }
            }
            this.isComplete = true;
        }
    }

    private void checkEntity(EntityLiving entity) {
        if (this.shouldKill(entity)) {
            CommandButcherTickTask.killEntity((Entity)entity);
            ++this.killCount;
            ++this.tickKillCount;
        }
    }

    private boolean shouldKill(EntityLiving entity) {
        String className = entity.getClass().getName();
        switch (this.mobType) {
            case ALL: {
                return true;
            }
            case HOSTILE: {
                if (entity instanceof EntityMob || entity instanceof EntityGhast) {
                    return true;
                }
                if (entity instanceof EntitySlime && ((EntitySlime)entity).func_70809_q() > 0) {
                    return true;
                }
                return MobTypeRegistry.getCollectionForMobType(EnumMobType.HOSTILE).contains(className);
            }
            case PASSIVE: {
                if (entity instanceof EntityTameable && ((EntityTameable)entity).func_70909_n()) {
                    return false;
                }
                if (MobTypeRegistry.getCollectionForMobType(EnumMobType.TAMEABLE).contains(className) && MobTypeRegistry.isTamed(entity)) {
                    return false;
                }
                if (entity instanceof EntityAnimal || entity instanceof EntityAmbientCreature || entity instanceof EntitySquid) {
                    return true;
                }
                return MobTypeRegistry.getCollectionForMobType(EnumMobType.PASSIVE).contains(className);
            }
            case VILLAGER: {
                if (entity instanceof EntityVillager) {
                    return true;
                }
                return MobTypeRegistry.getCollectionForMobType(EnumMobType.VILLAGER).contains(className);
            }
            case TAMABLE: {
                return entity instanceof EntityTameable;
            }
            case TAMED: {
                return entity instanceof EntityTameable && ((EntityTameable)entity).func_70909_n();
            }
            case GOLEM: {
                if (entity instanceof EntityGolem) {
                    return true;
                }
                return MobTypeRegistry.getCollectionForMobType(EnumMobType.GOLEM).contains(className);
            }
            case BOSS: {
                if (entity instanceof EntityDragon || entity instanceof EntityWither) {
                    return true;
                }
                if (!MobTypeRegistry.getCollectionForMobType(EnumMobType.BOSS).contains(className)) break;
                return true;
            }
        }
        return false;
    }

    private static void killEntity(Entity entity) {
        if (entity instanceof EntityDragon) {
            for (EntityDragonPart part : ((EntityDragon)entity).field_70977_g) {
                part.func_70106_y();
            }
        }
        entity.func_70106_y();
    }

    @Override
    public void onComplete() {
        OutputHandler.chatConfirmation(this.sender, String.format("%s mobs killed.", this.killCount));
    }

    @Override
    public boolean isComplete() {
        return this.isComplete;
    }

    public static enum ButcherMobType {
        ALL,
        HOSTILE,
        PASSIVE,
        VILLAGER,
        TAMABLE,
        TAMED,
        GOLEM,
        BOSS;


        public static List<String> getNames() {
            ArrayList<String> result = new ArrayList<String>();
            for (ButcherMobType type : ButcherMobType.values()) {
                result.add(type.name());
            }
            return result;
        }
    }
}

