/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.commands;

import com.forgeessentials.commands.util.CommandDataManager;
import com.forgeessentials.commands.util.FEcmdModuleCommands;
import com.forgeessentials.commands.util.WeatherTimeData;
import com.forgeessentials.util.FunctionHelper;
import com.forgeessentials.util.OutputHandler;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.permissions.PermissionsManager;

public class CommandWeather
extends FEcmdModuleCommands {
    public String func_71517_b() {
        return "weather";
    }

    @Override
    public PermissionsManager.RegisteredPermValue getDefaultPermission() {
        return PermissionsManager.RegisteredPermValue.OP;
    }

    @Override
    public void func_71515_b(ICommandSender sender, String[] args) {
        if (args.length != 0 && FunctionHelper.isNumeric(args[0])) {
            String[] newArgs = new String[args.length - 1];
            for (int i = 0; i < args.length - 1; ++i) {
                newArgs[i] = args[i + 1];
            }
            String msg = this.doCmd(sender, (World)DimensionManager.getWorld((int)CommandWeather.func_71526_a((ICommandSender)sender, (String)args[0])), newArgs);
            if (msg != null) {
                OutputHandler.chatConfirmation(sender, msg);
            }
        } else {
            String msg = null;
            for (WorldServer world : DimensionManager.getWorlds()) {
                msg = this.doCmd(sender, (World)world, args);
            }
            if (msg != null) {
                OutputHandler.chatConfirmation(sender, msg);
            }
        }
    }

    public String doCmd(ICommandSender sender, World world, String[] args) {
        if (args.length == 0) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        WeatherTimeData wt = CommandDataManager.WTmap.get(world.field_73011_w.field_76574_g);
        wt.weatherSpecified = true;
        if (args[0].equalsIgnoreCase("rain")) {
            if (args.length == 1) {
                wt.rain = !wt.rain;
            } else if (args[1].equalsIgnoreCase("on")) {
                wt.rain = true;
                wt.storm = false;
            } else if (args[1].equalsIgnoreCase("off")) {
                wt.rain = false;
            } else {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
            CommandDataManager.WTmap.put(wt.dimID, wt);
            return "Rain permanently turned " + (wt.rain ? "on" : "off");
        }
        if (args[0].equalsIgnoreCase("storm")) {
            if (args.length == 1) {
                wt.storm = !wt.storm;
            } else if (args[1].equalsIgnoreCase("on")) {
                wt.storm = true;
                wt.rain = false;
            } else if (args[1].equalsIgnoreCase("off")) {
                wt.storm = false;
            } else {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
            CommandDataManager.WTmap.put(wt.dimID, wt);
            return "Storms permanently turned " + (wt.storm ? "on" : "off");
        }
        if (args[0].equalsIgnoreCase("default")) {
            wt.weatherSpecified = false;
            CommandDataManager.WTmap.put(wt.dimID, wt);
            return "Weather reset to default";
        }
        throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
    }

    @Override
    public boolean canConsoleUseCommand() {
        return true;
    }

    public String func_71518_a(ICommandSender sender) {
        return "/weather <rain|storm|default> [on|off] Allows for permanent manipulation of the weather.";
    }
}

