/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.commands;

import com.forgeessentials.commands.util.CommandDataManager;
import com.forgeessentials.commands.util.CommandsEventHandler;
import com.forgeessentials.commands.util.FEcmdModuleCommands;
import com.forgeessentials.commands.util.WeatherTimeData;
import com.forgeessentials.util.FunctionHelper;
import com.forgeessentials.util.OutputHandler;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.permissions.PermissionsManager;

public class CommandTime
extends FEcmdModuleCommands {
    public String func_71517_b() {
        return "time";
    }

    @Override
    public PermissionsManager.RegisteredPermValue getDefaultPermission() {
        return PermissionsManager.RegisteredPermValue.OP;
    }

    @Override
    public void processCommandPlayer(EntityPlayerMP sender, String[] args) {
        if (args.length != 0 && FunctionHelper.isNumeric(args[0])) {
            String[] newArgs = new String[args.length - 1];
            for (int i = 0; i < args.length - 1; ++i) {
                newArgs[i] = args[i + 1];
            }
            String msg = this.doCmd((ICommandSender)sender, (World)DimensionManager.getWorld((int)CommandTime.func_71526_a((ICommandSender)sender, (String)args[0])), newArgs);
            if (msg != null) {
                OutputHandler.chatConfirmation((ICommandSender)sender, msg);
            }
        } else {
            String msg = null;
            for (WorldServer world : DimensionManager.getWorlds()) {
                msg = this.doCmd((ICommandSender)sender, (World)world, args);
            }
            if (msg != null) {
                OutputHandler.chatConfirmation((ICommandSender)sender, msg);
            }
        }
    }

    @Override
    public void processCommandConsole(ICommandSender sender, String[] args) {
        if (args.length != 0 && FunctionHelper.isNumeric(args[0])) {
            String[] newArgs = new String[args.length - 1];
            for (int i = 0; i < args.length - 1; ++i) {
                newArgs[i] = args[i + 1];
            }
            String msg = this.doCmd(sender, (World)DimensionManager.getWorld((int)CommandTime.func_71526_a((ICommandSender)sender, (String)args[0])), newArgs);
            if (msg != null) {
                OutputHandler.chatConfirmation(sender, msg);
            }
        } else {
            String msg = null;
            for (WorldServer world : DimensionManager.getWorlds()) {
                msg = this.doCmd(sender, (World)world, args);
            }
            if (msg != null) {
                OutputHandler.chatConfirmation(sender, msg);
            }
        }
    }

    public String doCmd(ICommandSender sender, World world, String[] args) {
        if (args.length == 0) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        switch (args[0]) {
            case "set": {
                if (args[1].equalsIgnoreCase("day")) {
                    CommandsEventHandler.makeWorldTimeHours(world, 1);
                } else if (args[1].equalsIgnoreCase("night")) {
                    CommandsEventHandler.makeWorldTimeHours(world, 14);
                } else {
                    world.func_72877_b((long)CommandTime.func_71526_a((ICommandSender)sender, (String)args[1]));
                }
                WeatherTimeData wt = CommandDataManager.WTmap.get(world.field_73011_w.field_76574_g);
                wt.freezeTime = world.func_72820_D();
                return String.format("Set time to %s.", args[1]);
            }
            case "add": {
                if (args.length == 1) {
                    throw new CommandException("Improper syntax. Please try this instead: [dimID, none for all] <freeze|lock|set|add> <time (number)|day|night>", new Object[0]);
                }
                world.func_72877_b(world.func_72820_D() + (long)CommandTime.func_71526_a((ICommandSender)sender, (String)args[1]));
                WeatherTimeData wt = CommandDataManager.WTmap.get(world.field_73011_w.field_76574_g);
                wt.freezeTime = world.func_72820_D();
                return String.format("Added %d to the current time.", args[1]);
            }
            case "freeze": {
                WeatherTimeData wt = CommandDataManager.WTmap.get(world.field_73011_w.field_76574_g);
                wt.freezeTime = world.func_72820_D();
                wt.timeFreeze = !wt.timeFreeze;
                return "Time freeze" + (wt.timeFreeze ? "on" : "off");
            }
            case "lock": {
                WeatherTimeData wt = CommandDataManager.WTmap.get(world.field_73011_w.field_76574_g);
                if (args.length == 1) {
                    wt.timeSpecified = !wt.timeSpecified;
                } else {
                    wt.timeSpecified = true;
                    if (args[1].equalsIgnoreCase("day")) {
                        wt.day = true;
                    } else if (args[1].equalsIgnoreCase("night")) {
                        wt.day = false;
                    } else {
                        throw new CommandException("Improper syntax. Please try this instead: [dimID, none for all] <freeze|lock|set|add> <time (number)|day|night>", new Object[0]);
                    }
                }
                return String.format("Locked time to %s.", args[1]);
            }
        }
        throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
    }

    @Override
    public boolean canConsoleUseCommand() {
        return true;
    }

    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            return CommandTime.func_71530_a((String[])args, (String[])new String[]{"freeze", "set", "add", "lock"});
        }
        if (args[0].equalsIgnoreCase("set") || args[0].equalsIgnoreCase("lock")) {
            return CommandTime.func_71530_a((String[])args, (String[])new String[]{"day", "night"});
        }
        return null;
    }

    public String func_71518_a(ICommandSender sender) {
        return "/time [dimID, none for all] <freeze|lock|set|add> <time (number)|day|night> Manipulate time.";
    }
}

