/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.commands;

import com.forgeessentials.api.APIRegistry;
import com.forgeessentials.commands.util.FEcmdModuleCommands;
import com.forgeessentials.core.ForgeEssentials;
import com.forgeessentials.util.FunctionHelper;
import com.forgeessentials.util.OutputHandler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.permissions.PermissionsManager;

public class CommandRules
extends FEcmdModuleCommands {
    public static final String[] autocomargs = new String[]{"add", "remove", "move", "change", "book"};
    public static ArrayList<String> rules;
    public static File rulesFile;

    @Override
    public void loadConfig(Configuration config, String category) {
        rulesFile = new File(ForgeEssentials.getFEDirectory(), config.get(category, "filename", "rules.txt").getString());
        rules = this.loadRules();
    }

    public ArrayList<String> loadRules() {
        ArrayList<String> rules = new ArrayList<String>();
        OutputHandler.felog.info("Loading rules");
        if (!rulesFile.exists()) {
            try {
                OutputHandler.felog.info("No rules file found. Generating with default rules..");
                rulesFile.createNewFile();
                FileOutputStream stream = new FileOutputStream(rulesFile);
                OutputStreamWriter streamWriter = new OutputStreamWriter(stream);
                BufferedWriter writer = new BufferedWriter(streamWriter);
                writer.write("# " + rulesFile.getName() + " | numbers are automatically added");
                writer.newLine();
                writer.write("Obey the Admins");
                rules.add("Obey the Admins");
                writer.newLine();
                writer.write("Do not grief");
                rules.add("Do not grief");
                writer.newLine();
                writer.close();
                streamWriter.close();
                stream.close();
                OutputHandler.felog.info("Completed generating rules file.");
            }
            catch (IOException e) {
                OutputHandler.felog.severe("Error writing the Rules file: " + rulesFile.getName());
            }
        } else {
            try {
                OutputHandler.felog.info("Rules file found. Reading...");
                FileInputStream stream = new FileInputStream(rulesFile);
                InputStreamReader streamReader = new InputStreamReader(stream);
                BufferedReader reader = new BufferedReader(streamReader);
                String read = reader.readLine();
                int counter = 0;
                while (read != null) {
                    if (read.startsWith("#")) {
                        read = reader.readLine();
                        continue;
                    }
                    rules.add(read);
                    read = reader.readLine();
                    ++counter;
                }
                reader.close();
                streamReader.close();
                stream.close();
                OutputHandler.felog.info("Completed reading rules file. " + counter + " rules read.");
            }
            catch (IOException e) {
                OutputHandler.felog.severe("Error writing the Rules file: " + rulesFile.getName());
            }
        }
        return rules;
    }

    public void saveRules() {
        try {
            OutputHandler.felog.info("Saving rules");
            if (!rulesFile.exists()) {
                rulesFile.createNewFile();
            }
            FileOutputStream stream = new FileOutputStream(rulesFile);
            OutputStreamWriter streamWriter = new OutputStreamWriter(stream);
            BufferedWriter writer = new BufferedWriter(streamWriter);
            writer.write("# " + rulesFile.getName() + " | numbers are automatically added");
            writer.newLine();
            for (String rule : rules) {
                writer.write(rule);
                writer.newLine();
            }
            writer.close();
            streamWriter.close();
            stream.close();
            OutputHandler.felog.info("Completed saving rules file.");
        }
        catch (IOException e) {
            OutputHandler.felog.severe("Error writing the Rules file: " + rulesFile.getName());
        }
    }

    public String func_71517_b() {
        return "rules";
    }

    @Override
    public void processCommandPlayer(EntityPlayerMP sender, String[] args) {
        if (args.length == 0) {
            for (String rule : rules) {
                OutputHandler.chatNotification((ICommandSender)sender, rule);
            }
            return;
        }
        if (args[0].equalsIgnoreCase("book")) {
            NBTTagCompound tag = new NBTTagCompound();
            NBTTagList pages = new NBTTagList();
            HashMap<String, String> map = new HashMap<String, String>();
            for (int i = 0; i < rules.size(); ++i) {
                map.put(EnumChatFormatting.UNDERLINE + "Rule #" + (i + 1) + "\n\n", EnumChatFormatting.RESET + FunctionHelper.formatColors(rules.get(i)));
            }
            TreeSet keys = new TreeSet(map.keySet());
            for (String name : keys) {
                pages.func_74742_a((NBTBase)new NBTTagString(name + (String)map.get(name)));
            }
            tag.func_74778_a("author", "ForgeEssentials");
            tag.func_74778_a("title", "Rule Book");
            tag.func_74782_a("pages", (NBTBase)pages);
            ItemStack is = new ItemStack(Items.field_151164_bB);
            is.func_77982_d(tag);
            sender.field_71071_by.func_70441_a(is);
            return;
        }
        if (args.length == 1) {
            if (args[0].equalsIgnoreCase("help")) {
                OutputHandler.chatNotification((ICommandSender)sender, " - /rules [#]");
                if (PermissionsManager.checkPermission((EntityPlayer)sender, this.getPermissionNode() + ".edit")) {
                    OutputHandler.chatNotification((ICommandSender)sender, " - /rules &lt;#> [changedRule]");
                    OutputHandler.chatNotification((ICommandSender)sender, " - /rules add &lt;newRule>");
                    OutputHandler.chatNotification((ICommandSender)sender, " - /rules remove &lt;#>");
                    OutputHandler.chatNotification((ICommandSender)sender, " - /rules move &lt;#> &lt;#>");
                }
                return;
            }
            OutputHandler.chatNotification((ICommandSender)sender, rules.get(CommandRules.func_71532_a((ICommandSender)sender, (String)args[0], (int)1, (int)rules.size()) - 1));
            return;
        }
        if (!PermissionsManager.checkPermission((EntityPlayer)sender, this.getPermissionNode() + ".edit")) {
            OutputHandler.chatError((ICommandSender)sender, "You have insufficient permissions to do that. If you believe you received this message in error, please talk to a server admin.");
            return;
        }
        if (args[0].equalsIgnoreCase("remove")) {
            int index = CommandRules.func_71532_a((ICommandSender)sender, (String)args[1], (int)1, (int)rules.size());
            rules.remove(index - 1);
            OutputHandler.chatConfirmation((ICommandSender)sender, String.format("Rule # %s removed", args[1]));
        } else if (args[0].equalsIgnoreCase("add")) {
            String newRule = "";
            for (int i = 1; i < args.length; ++i) {
                newRule = newRule + args[i] + " ";
            }
            newRule = FunctionHelper.formatColors(newRule);
            rules.add(newRule);
            OutputHandler.chatConfirmation((ICommandSender)sender, String.format("Rule added as # %s.", args[1]));
        } else if (args[0].equalsIgnoreCase("move")) {
            int index = CommandRules.func_71532_a((ICommandSender)sender, (String)args[1], (int)1, (int)rules.size());
            String temp = rules.remove(index - 1);
            index = CommandRules.func_71528_a((ICommandSender)sender, (String)args[2], (int)1);
            if (index < rules.size()) {
                rules.add(index - 1, temp);
                OutputHandler.chatConfirmation((ICommandSender)sender, String.format("Rule # %1$s moved to # %2$s", args[1], args[2]));
            } else {
                rules.add(temp);
                OutputHandler.chatConfirmation((ICommandSender)sender, String.format("Rule # %1$s moved to last position.", args[1]));
            }
        } else if (args[0].equalsIgnoreCase("change")) {
            int index = CommandRules.func_71532_a((ICommandSender)sender, (String)args[1], (int)1, (int)rules.size());
            String newRule = "";
            for (int i = 2; i < args.length; ++i) {
                newRule = newRule + args[i] + " ";
            }
            newRule = FunctionHelper.formatColors(newRule);
            rules.set(index - 1, newRule);
            OutputHandler.chatConfirmation((ICommandSender)sender, String.format("Rules # %1$s changed to '%2$s'.", index + "", newRule));
        } else {
            throw new CommandException(this.func_71518_a((ICommandSender)sender), new Object[0]);
        }
        this.saveRules();
    }

    @Override
    public void processCommandConsole(ICommandSender sender, String[] args) {
        if (args.length == 0) {
            for (String rule : rules) {
                OutputHandler.sendMessage(sender, rule);
            }
            return;
        }
        if (args.length == 1) {
            if (args[0].equalsIgnoreCase("help")) {
                OutputHandler.chatConfirmation(sender, " - /rules [#]");
                OutputHandler.chatConfirmation(sender, " - /rules &lt;#> [changedRule]");
                OutputHandler.chatConfirmation(sender, " - /rules add &lt;newRule>");
                OutputHandler.chatConfirmation(sender, " - /rules remove &lt;#>");
                OutputHandler.chatConfirmation(sender, " - /rules move &lt;#> &lt;#>");
            }
            OutputHandler.sendMessage(sender, rules.get(CommandRules.func_71532_a((ICommandSender)sender, (String)args[0], (int)1, (int)rules.size()) - 1));
            return;
        }
        if (args[0].equalsIgnoreCase("remove")) {
            int index = CommandRules.func_71532_a((ICommandSender)sender, (String)args[1], (int)1, (int)rules.size());
            rules.remove(index - 1);
            OutputHandler.chatConfirmation(sender, String.format("Rule # %s removed", args[1]));
        } else if (args[0].equalsIgnoreCase("add")) {
            String newRule = "";
            for (int i = 1; i < args.length; ++i) {
                newRule = newRule + args[i] + " ";
            }
            newRule = FunctionHelper.formatColors(newRule);
            rules.add(newRule);
            OutputHandler.chatConfirmation(sender, String.format("Rule added as # %s.", args[1]));
        } else if (args[0].equalsIgnoreCase("move")) {
            int index = CommandRules.func_71532_a((ICommandSender)sender, (String)args[1], (int)1, (int)rules.size());
            String temp = rules.remove(index - 1);
            index = CommandRules.func_71528_a((ICommandSender)sender, (String)args[2], (int)1);
            if (index < rules.size()) {
                rules.add(index - 1, temp);
                OutputHandler.chatConfirmation(sender, String.format("Rule # %1$s moved to # %2$s", args[1], args[2]));
            } else {
                rules.add(temp);
                OutputHandler.chatConfirmation(sender, String.format("Rule # %1$s moved to last position.", args[1]));
            }
        } else if (args[0].equalsIgnoreCase("change")) {
            int index = CommandRules.func_71532_a((ICommandSender)sender, (String)args[1], (int)1, (int)rules.size());
            String newRule = "";
            for (int i = 2; i < args.length; ++i) {
                newRule = newRule + args[i] + " ";
            }
            newRule = FunctionHelper.formatColors(newRule);
            rules.set(index - 1, newRule);
            OutputHandler.chatConfirmation(sender, String.format("Rules # %1$s changed to '%2$s'.", index + "", newRule));
        } else {
            throw new CommandException(this.func_71518_a(sender), new Object[0]);
        }
        this.saveRules();
    }

    @Override
    public boolean canConsoleUseCommand() {
        return true;
    }

    @Override
    public void registerExtraPermissions() {
        APIRegistry.perms.registerPermission(this.getPermissionNode() + ".edit", PermissionsManager.RegisteredPermValue.OP);
    }

    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            return CommandRules.func_71530_a((String[])args, (String[])autocomargs);
        }
        if (args.length == 2) {
            ArrayList<String> opt = new ArrayList<String>();
            for (int i = 1; i < rules.size() + 1; ++i) {
                opt.add(i + "");
            }
            return opt;
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("move")) {
            ArrayList<String> opt = new ArrayList<String>();
            for (int i = 1; i < rules.size() + 2; ++i) {
                opt.add(i + "");
            }
            return opt;
        }
        return null;
    }

    @Override
    public PermissionsManager.RegisteredPermValue getDefaultPermission() {
        return PermissionsManager.RegisteredPermValue.TRUE;
    }

    public String func_71518_a(ICommandSender sender) {
        if (sender instanceof EntityPlayer) {
            return "/rules [#|add|remove|move|change|help|book] Gets or sets the rules of the server.";
        }
        return "/rules [#|add|remove|move|change|help] Gets or sets the rules of the server.";
    }

    static {
        rulesFile = new File(ForgeEssentials.getFEDirectory(), "rules.txt");
    }
}

