/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.commands;

import com.forgeessentials.api.APIRegistry;
import com.forgeessentials.commands.util.CommandDataManager;
import com.forgeessentials.commands.util.FEcmdModuleCommands;
import com.forgeessentials.commands.util.Kit;
import com.forgeessentials.util.FunctionHelper;
import com.forgeessentials.util.OutputHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.permissions.PermissionsManager;

public class CommandKit
extends FEcmdModuleCommands {
    public String func_71517_b() {
        return "kit";
    }

    @Override
    public void processCommandPlayer(EntityPlayerMP sender, String[] args) {
        if (args.length == 0) {
            OutputHandler.chatNotification((ICommandSender)sender, "Available kits:");
            String msg = "";
            for (Kit kit : CommandDataManager.kits.values()) {
                if (!PermissionsManager.checkPermission((EntityPlayer)sender, this.getPermissionNode() + "." + kit.getName())) continue;
                msg = kit.getName() + ", " + msg;
            }
            OutputHandler.chatNotification((ICommandSender)sender, msg);
            return;
        }
        if (args.length == 1) {
            if (CommandDataManager.kits.containsKey(args[0].toLowerCase())) {
                if (PermissionsManager.checkPermission((EntityPlayer)sender, this.getPermissionNode() + "." + args[0].toLowerCase())) {
                    CommandDataManager.kits.get(args[0].toLowerCase()).giveKit((EntityPlayer)sender);
                } else {
                    OutputHandler.chatError((ICommandSender)sender, "You have insufficient permissions to do that. If you believe you received this message in error, please talk to a server admin.");
                }
            } else {
                OutputHandler.chatError((ICommandSender)sender, "Kit doesn't exist - either make it or try another kit?");
            }
            return;
        }
        if (args[1].equalsIgnoreCase("set") && PermissionsManager.checkPermission((EntityPlayer)sender, this.getPermissionNode() + ".admin") && args.length == 3) {
            if (!CommandDataManager.kits.containsKey(args[0].toLowerCase())) {
                int cooldown = CommandKit.func_71528_a((ICommandSender)sender, (String)args[2], (int)0);
                new Kit((EntityPlayer)sender, args[0].toLowerCase(), cooldown);
                OutputHandler.chatConfirmation((ICommandSender)sender, "Kit created successfully. %c sec cooldown.".replaceAll("%c", "" + FunctionHelper.parseTime(cooldown)));
            } else {
                OutputHandler.chatError((ICommandSender)sender, "This kit already exists.");
            }
            return;
        }
        if (args[1].equalsIgnoreCase("del") && PermissionsManager.checkPermission((EntityPlayer)sender, this.getPermissionNode() + ".admin") && args.length == 2) {
            if (CommandDataManager.kits.containsKey(args[0].toLowerCase())) {
                CommandDataManager.removeKit(CommandDataManager.kits.get(args[0].toLowerCase()));
                OutputHandler.chatConfirmation((ICommandSender)sender, "Kit removed.");
            } else {
                OutputHandler.chatError((ICommandSender)sender, "Kit doesn't exist - either make it or try another kit?");
            }
            return;
        }
        throw new WrongUsageException(this.func_71518_a((ICommandSender)sender), new Object[0]);
    }

    @Override
    public boolean canConsoleUseCommand() {
        return false;
    }

    @Override
    public void registerExtraPermissions() {
        APIRegistry.perms.registerPermission(this.getPermissionNode() + ".admin", PermissionsManager.RegisteredPermValue.OP);
        APIRegistry.perms.registerPermission("fe.TickHandlerCommands.BypassKitCooldown", PermissionsManager.RegisteredPermValue.OP);
    }

    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            ArrayList<String> list = new ArrayList<String>();
            list.addAll(CommandDataManager.kits.keySet());
            list.add("set");
            list.add("del");
            return CommandKit.func_71531_a((String[])args, list);
        }
        throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
    }

    @Override
    public PermissionsManager.RegisteredPermValue getDefaultPermission() {
        return PermissionsManager.RegisteredPermValue.TRUE;
    }

    public String func_71518_a(ICommandSender sender) {
        return "/kit [name] OR [name] [set|del] <cooldown> Allows you to receive free kits which are pre-defined by the server owner.";
    }
}

