/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.commands;

import com.forgeessentials.api.APIRegistry;
import com.forgeessentials.commands.util.FEcmdModuleCommands;
import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.util.UserIdent;
import cpw.mods.fml.common.FMLCommonHandler;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.StatCollector;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.permissions.PermissionsManager;

public class CommandGameMode
extends FEcmdModuleCommands {
    public String func_71517_b() {
        return "gamemode";
    }

    @Override
    public String[] getDefaultAliases() {
        return new String[]{"gm"};
    }

    @Override
    public void processCommandPlayer(EntityPlayerMP sender, String[] args) {
        switch (args.length) {
            case 0: {
                this.setGameMode((EntityPlayer)sender);
                break;
            }
            case 1: {
                WorldSettings.GameType gm = this.getGameTypeFromString(args[0]);
                if (gm != null) {
                    this.setGameMode((ICommandSender)sender, (EntityPlayer)sender, gm);
                    break;
                }
                this.setGameMode((ICommandSender)sender, args[0]);
                break;
            }
            default: {
                WorldSettings.GameType gm = this.getGameTypeFromString(args[0]);
                if (gm != null) {
                    for (int i = 1; i < args.length; ++i) {
                        this.setGameMode((ICommandSender)sender, args[i], gm);
                    }
                    break;
                }
                throw new WrongUsageException("commands.gamemode.usage", new Object[0]);
            }
        }
    }

    @Override
    public void processCommandConsole(ICommandSender sender, String[] args) {
        switch (args.length) {
            case 0: {
                throw new WrongUsageException("commands.gamemode.usage", new Object[0]);
            }
            case 1: {
                WorldSettings.GameType gm = this.getGameTypeFromString(args[0]);
                if (gm != null) {
                    throw new WrongUsageException("commands.gamemode.usage", new Object[0]);
                }
                this.setGameMode(sender, args[0]);
                break;
            }
            default: {
                WorldSettings.GameType gm = this.getGameTypeFromString(args[0]);
                if (gm != null) {
                    for (int i = 1; i < args.length; ++i) {
                        this.setGameMode(sender, args[i], gm);
                    }
                    break;
                }
                throw new WrongUsageException("commands.gamemode.usage", new Object[0]);
            }
        }
    }

    public void setGameMode(EntityPlayer sender) {
        this.setGameMode((ICommandSender)sender, sender, sender.field_71075_bZ.field_75098_d ? WorldSettings.GameType.SURVIVAL : WorldSettings.GameType.CREATIVE);
    }

    public void setGameMode(ICommandSender sender, String target) {
        EntityPlayerMP player = UserIdent.getPlayerByMatchOrUsername(sender, target);
        if (player == null) {
            OutputHandler.chatError(sender, String.format("Unable to find player: %1$s.", target));
            return;
        }
        this.setGameMode(sender, target, player.field_71075_bZ.field_75098_d ? WorldSettings.GameType.SURVIVAL : WorldSettings.GameType.CREATIVE);
    }

    public void setGameMode(ICommandSender sender, String target, WorldSettings.GameType mode) {
        EntityPlayerMP player = UserIdent.getPlayerByMatchOrUsername(sender, target);
        if (player == null) {
            OutputHandler.chatError(sender, String.format("Unable to find player: %1$s.", target));
            return;
        }
        this.setGameMode(sender, (EntityPlayer)player, mode);
    }

    public void setGameMode(ICommandSender sender, EntityPlayer target, WorldSettings.GameType mode) {
        target.func_71033_a(mode);
        target.field_70143_R = 0.0f;
        String modeName = StatCollector.func_74838_a((String)("gameMode." + mode.func_77149_b()));
        OutputHandler.chatNotification(sender, String.format("%1$s's gamemode was changed to %2$s.", target.func_70005_c_(), modeName));
    }

    private WorldSettings.GameType getGameTypeFromString(String string) {
        if (string.equalsIgnoreCase(WorldSettings.GameType.SURVIVAL.func_77149_b()) || string.equalsIgnoreCase("s") || string.equals("0")) {
            return WorldSettings.GameType.SURVIVAL;
        }
        if (string.equalsIgnoreCase(WorldSettings.GameType.CREATIVE.func_77149_b()) || string.equalsIgnoreCase("c") || string.equals("1")) {
            return WorldSettings.GameType.CREATIVE;
        }
        if (string.equalsIgnoreCase(WorldSettings.GameType.ADVENTURE.func_77149_b()) || string.equalsIgnoreCase("a") || string.equals("2")) {
            return WorldSettings.GameType.ADVENTURE;
        }
        return null;
    }

    @Override
    public boolean canConsoleUseCommand() {
        return true;
    }

    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            return CommandGameMode.func_71530_a((String[])args, (String[])new String[]{"survival", "creative", "adventure"});
        }
        return CommandGameMode.func_71530_a((String[])args, (String[])FMLCommonHandler.instance().getMinecraftServerInstance().func_71213_z());
    }

    @Override
    public void registerExtraPermissions() {
        APIRegistry.perms.registerPermission(this.getPermissionNode() + ".others", PermissionsManager.RegisteredPermValue.OP);
    }

    @Override
    public PermissionsManager.RegisteredPermValue getDefaultPermission() {
        return PermissionsManager.RegisteredPermValue.OP;
    }

    public String func_71518_a(ICommandSender sender) {
        if (sender instanceof EntityPlayer) {
            return "/gamemode [gamemode] [player(s)] Change a player's gamemode.";
        }
        return "/gamemode [gamemode] <player(s)> Change a player's gamemode.";
    }
}

