/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.commands;

import com.forgeessentials.commands.util.CommandButcherTickTask;
import com.forgeessentials.commands.util.FEcmdModuleCommands;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntityCommandBlock;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.permissions.PermissionsManager;

public class CommandButcher
extends FEcmdModuleCommands {
    public static List<String> typeList = CommandButcherTickTask.ButcherMobType.getNames();

    public String func_71517_b() {
        return "febutcher";
    }

    @Override
    public String[] getDefaultAliases() {
        return new String[]{"butcher"};
    }

    public List<String> func_71516_a(ICommandSender par1ICommandSender, String[] args) {
        if (args.length == 1) {
            return CommandButcher.func_71530_a((String[])args, (String[])new String[]{"-1"});
        }
        if (args.length == 2) {
            return CommandButcher.getListOfStringsMatchingLastWord(args, typeList);
        }
        return null;
    }

    @Override
    public void processCommandPlayer(EntityPlayerMP sender, String[] args) {
        int radius = -1;
        double x = sender.field_70165_t;
        double y = sender.field_70163_u;
        double z = sender.field_70161_v;
        World world = sender.field_70170_p;
        String mobType = CommandButcherTickTask.ButcherMobType.HOSTILE.toString();
        LinkedList<String> argsStack = new LinkedList<String>(Arrays.asList(args));
        if (!argsStack.isEmpty()) {
            String radiusValue = (String)argsStack.remove();
            radius = radiusValue.equalsIgnoreCase("world") ? -1 : CommandButcher.func_71528_a((ICommandSender)sender, (String)radiusValue, (int)0);
        }
        if (!argsStack.isEmpty()) {
            mobType = (String)argsStack.remove();
        }
        if (!argsStack.isEmpty()) {
            if (argsStack.size() < 3) {
                throw new CommandException("Improper syntax: <radius> [type] [x y z] [world]", new Object[0]);
            }
            x = CommandButcher.parseDouble((ICommandSender)sender, (String)argsStack.remove(), sender.field_70165_t);
            y = CommandButcher.parseDouble((ICommandSender)sender, (String)argsStack.remove(), sender.field_70163_u);
            z = CommandButcher.parseDouble((ICommandSender)sender, (String)argsStack.remove(), sender.field_70161_v);
        }
        if (!argsStack.isEmpty() && (world = DimensionManager.getWorld((int)CommandButcher.func_71526_a((ICommandSender)sender, (String)((String)argsStack.remove())))) == null) {
            throw new CommandException("The specified dimension does not exist", new Object[0]);
        }
        AxisAlignedBB pool = AxisAlignedBB.func_72330_a((double)(x - (double)radius), (double)(y - (double)radius), (double)(z - (double)radius), (double)(x + (double)radius + 1.0), (double)(y + (double)radius + 1.0), (double)(z + (double)radius + 1.0));
        CommandButcherTickTask.schedule((ICommandSender)sender, world, mobType, pool, radius);
    }

    @Override
    public void processCommandConsole(ICommandSender sender, String[] args) {
        int radius = -1;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        WorldServer world = DimensionManager.getWorld((int)0);
        String mobType = CommandButcherTickTask.ButcherMobType.HOSTILE.toString();
        LinkedList<String> argsStack = new LinkedList<String>(Arrays.asList(args));
        if (!argsStack.isEmpty()) {
            String radiusValue = (String)argsStack.remove();
            radius = radiusValue.equalsIgnoreCase("world") ? -1 : CommandButcher.func_71528_a((ICommandSender)sender, (String)radiusValue, (int)0);
        }
        if (!argsStack.isEmpty()) {
            mobType = (String)argsStack.remove();
        }
        if (!argsStack.isEmpty()) {
            if (argsStack.size() < 3) {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
            x = CommandButcher.func_71526_a((ICommandSender)sender, (String)((String)argsStack.remove()));
            y = CommandButcher.func_71526_a((ICommandSender)sender, (String)((String)argsStack.remove()));
            z = CommandButcher.func_71526_a((ICommandSender)sender, (String)((String)argsStack.remove()));
        } else if (sender instanceof TileEntityCommandBlock) {
            TileEntityCommandBlock cb = (TileEntityCommandBlock)sender;
            world = cb.func_145831_w();
            x = cb.field_145851_c;
            y = cb.field_145848_d;
            z = cb.field_145849_e;
        } else {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        if (!argsStack.isEmpty() && (world = DimensionManager.getWorld((int)CommandButcher.func_71526_a((ICommandSender)sender, (String)((String)argsStack.remove())))) == null) {
            throw new CommandException("This dimension does not exist", new Object[0]);
        }
        AxisAlignedBB pool = AxisAlignedBB.func_72330_a((double)(x - (double)radius), (double)(y - (double)radius), (double)(z - (double)radius), (double)(x + (double)radius + 1.0), (double)(y + (double)radius + 1.0), (double)(z + (double)radius + 1.0));
        CommandButcherTickTask.schedule(sender, (World)world, mobType, pool, radius);
    }

    @Override
    public boolean canConsoleUseCommand() {
        return true;
    }

    @Override
    public PermissionsManager.RegisteredPermValue getDefaultPermission() {
        return PermissionsManager.RegisteredPermValue.OP;
    }

    public String func_71518_a(ICommandSender sender) {
        return "/butcher [radius|-1|world] [type] [x, y, z] Kills the type of mobs within the specified radius around the specified point in the specified world.";
    }
}

