/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.commands;

import com.forgeessentials.api.APIRegistry;
import com.forgeessentials.commands.util.AFKdata;
import com.forgeessentials.commands.util.CommandsEventHandler;
import com.forgeessentials.commands.util.FEcmdModuleCommands;
import com.forgeessentials.util.OutputHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.permissions.PermissionsManager;

public class CommandAFK
extends FEcmdModuleCommands {
    public static CommandAFK instance;
    public static List<UUID> afkList;
    public static int warmup;
    public static String outMessage;
    public static String inMessage;
    public static String selfOutMessage;
    public static String selfInMessage;
    public final String NOTICEPERM = this.getPermissionNode() + ".notice";

    public CommandAFK() {
        instance = this;
    }

    @Override
    public void loadConfig(Configuration config, String category) {
        warmup = config.get(category, "warmup", 5, "Time in sec. you have to stand still to activate AFK.").getInt();
        String messages = category + ".messages";
        outMessage = config.get(messages, "outMessage", "Player %s is now away").getString();
        inMessage = config.get(messages, "inMessage", "Player %s is no longer away").getString();
        selfOutMessage = config.get(messages, "selfOutMessage", "You are now away").getString();
        selfInMessage = config.get(messages, "selfInMessage", "You are no longer away").getString();
    }

    public String func_71517_b() {
        return "afk";
    }

    @Override
    public void processCommandPlayer(EntityPlayerMP sender, String[] args) {
        CommandsEventHandler.afkListToAdd.add(new AFKdata(sender));
        OutputHandler.chatConfirmation((ICommandSender)sender, String.format("Stand still for %d seconds.", warmup));
    }

    @Override
    public boolean canConsoleUseCommand() {
        return false;
    }

    public void abort(AFKdata afkData) {
        if (!afkData.player.field_71075_bZ.field_75098_d) {
            afkData.player.field_71075_bZ.field_75102_a = false;
        }
        afkData.player.func_71016_p();
        afkList.remove(afkData.player.getPersistentID());
        CommandsEventHandler.afkListToRemove.add(afkData);
        if (PermissionsManager.checkPermission((EntityPlayer)afkData.player, this.NOTICEPERM)) {
            OutputHandler.sendMessage(MinecraftServer.func_71276_C().func_71203_ab(), String.format(inMessage, afkData.player.getDisplayName()));
        } else {
            OutputHandler.chatConfirmation((ICommandSender)afkData.player, selfInMessage);
        }
    }

    public void makeAFK(AFKdata afkData) {
        afkData.player.field_71075_bZ.field_75102_a = true;
        afkData.player.func_71016_p();
        afkList.add(afkData.player.getPersistentID());
        if (PermissionsManager.checkPermission((EntityPlayer)afkData.player, this.NOTICEPERM)) {
            OutputHandler.sendMessage(MinecraftServer.func_71276_C().func_71203_ab(), String.format(outMessage, afkData.player.getDisplayName()));
        } else {
            OutputHandler.chatConfirmation((ICommandSender)afkData.player, selfOutMessage);
        }
    }

    @Override
    public void registerExtraPermissions() {
        APIRegistry.perms.registerPermission(this.NOTICEPERM, PermissionsManager.RegisteredPermValue.TRUE);
    }

    @Override
    public PermissionsManager.RegisteredPermValue getDefaultPermission() {
        return PermissionsManager.RegisteredPermValue.TRUE;
    }

    public String func_71518_a(ICommandSender sender) {
        return "/afk Mark yourself as away.";
    }

    static {
        afkList = new ArrayList<UUID>();
        warmup = 5;
    }
}

