/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.chat.irc;

import com.forgeessentials.api.APIRegistry;
import com.forgeessentials.chat.ConfigChat;
import com.forgeessentials.chat.irc.IRCHelper;
import com.forgeessentials.commons.selections.WorldPoint;
import com.forgeessentials.util.FunctionHelper;
import com.forgeessentials.util.UserIdent;
import com.google.common.base.Strings;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.entity.Entity;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.ServerChatEvent;

public class IRCChatFormatter {
    public static List<String> bannedWords = new ArrayList<String>();
    public static boolean censor;
    public static String censorSymbol;
    public static String gmS;
    public static String gmC;
    public static String gmA;
    public static int censorSlap;
    public static String ircHeader;

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void chatEvent(ServerChatEvent event) {
        if (event.player.getEntityData().func_74775_l("PlayerPersisted").func_74767_n("mute")) {
            event.setCanceled(true);
            return;
        }
        String message2 = event.message;
        String nickname = event.username;
        if (censor) {
            for (String word : bannedWords) {
                Pattern p = Pattern.compile("(?i)\\b" + word + "\\b");
                Matcher m = p.matcher(message2);
                while (m.find()) {
                    int startIndex = m.start();
                    int endIndex = m.end();
                    int length = endIndex - startIndex;
                    String replaceWith = Strings.repeat((String)censorSymbol, (int)length);
                    message2 = m.replaceAll(replaceWith);
                    if (censorSlap == 0) continue;
                    event.player.func_70097_a(DamageSource.field_76377_j, (float)censorSlap);
                }
            }
        }
        if (event.player.getEntityData().func_74775_l("PlayerPersisted").func_74764_b("nickname")) {
            nickname = event.player.getEntityData().func_74775_l("PlayerPersisted").func_74779_i("nickname");
        }
        String playerPrefix = FunctionHelper.formatColors(FunctionHelper.getPlayerPrefixSuffix(new UserIdent(event.player), false));
        String playerSuffix = FunctionHelper.formatColors(FunctionHelper.getPlayerPrefixSuffix(new UserIdent(event.player), true));
        String groupPrefix = FunctionHelper.formatColors(FunctionHelper.getPlayerGroupPrefixSuffix(new UserIdent(event.player), false));
        String groupSuffix = FunctionHelper.formatColors(FunctionHelper.getPlayerGroupPrefixSuffix(new UserIdent(event.player), true));
        String zoneID = APIRegistry.perms.getServerZone().getZoneAt(new WorldPoint((Entity)event.player)).getName();
        String rank = "";
        String format = ConfigChat.chatFormat;
        String string = format = ConfigChat.chatFormat == null || ConfigChat.chatFormat.trim().isEmpty() ? "<%username>%message" : ConfigChat.chatFormat;
        if (format.contains("%gm")) {
            String gmCode = "";
            gmCode = event.player.field_71134_c.func_73081_b().func_77145_d() ? gmC : (event.player.field_71134_c.func_73081_b().func_82752_c() ? gmA : gmS);
            format = FunctionHelper.replaceAllIgnoreCase(format, "%gm", gmCode);
        }
        float health = event.player.func_110143_aJ();
        format = FunctionHelper.replaceAllIgnoreCase(format, "%healthcolor", "");
        format = FunctionHelper.replaceAllIgnoreCase(format, "%rank", rank);
        format = FunctionHelper.replaceAllIgnoreCase(format, "%zone", zoneID);
        format = FunctionHelper.replaceAllIgnoreCase(format, "%health", "" + health);
        format = FunctionHelper.format(format);
        format = FunctionHelper.replaceAllIgnoreCase(format, "%playerPrefix", playerPrefix);
        format = FunctionHelper.replaceAllIgnoreCase(format, "%playerSuffix", playerSuffix);
        format = FunctionHelper.replaceAllIgnoreCase(format, "%groupPrefix", groupPrefix);
        format = FunctionHelper.replaceAllIgnoreCase(format, "%groupSuffix", groupSuffix);
        format = FunctionHelper.replaceAllIgnoreCase(format, "%username", nickname);
        format = FunctionHelper.replaceAllIgnoreCase(format, "%message", message2);
        IRCHelper.postIRC("<" + event.username + "> " + event.message);
    }

    public static String formatIRCHeader(String channel, String ircUser) {
        String format = ircHeader;
        format = FunctionHelper.replaceAllIgnoreCase(format, "%channel", channel);
        format = FunctionHelper.replaceAllIgnoreCase(format, "%ircUser", ircUser);
        return FunctionHelper.formatColors(format);
    }
}

