/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.chat.commands;

import com.forgeessentials.chat.commands.CommandMsg;
import com.forgeessentials.chat.irc.IRCHelper;
import com.forgeessentials.core.commands.ForgeEssentialsCommandBase;
import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.util.UserIdent;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.permissions.PermissionsManager;

public class CommandR
extends ForgeEssentialsCommandBase {
    public String func_71517_b() {
        return "r";
    }

    @Override
    public void processCommandPlayer(EntityPlayerMP sender, String[] args) {
        if (args.length == 0) {
            OutputHandler.chatError((ICommandSender)sender, "Improper syntax. Please try this instead: /r <message>");
            return;
        }
        if (args.length > 0) {
            String target = CommandMsg.getPlayerReply(sender.func_70005_c_());
            if (target == null) {
                OutputHandler.chatError((ICommandSender)sender, "You have no previous recorded message recipient.");
                return;
            }
            if (target.equalsIgnoreCase("server")) {
                String senderMessage = EnumChatFormatting.GOLD + "[ me -> " + EnumChatFormatting.DARK_PURPLE + "Server" + EnumChatFormatting.GOLD + "] " + EnumChatFormatting.GRAY;
                String receiverMessage = EnumChatFormatting.GOLD + "[" + EnumChatFormatting.DARK_PURPLE + "Server" + EnumChatFormatting.GOLD + " -> me ] ";
                for (int i = 0; i < args.length; ++i) {
                    receiverMessage = receiverMessage + args[i];
                    senderMessage = senderMessage + args[i];
                    if (i == args.length - 1) continue;
                    receiverMessage = receiverMessage + " ";
                    senderMessage = senderMessage + " ";
                }
                OutputHandler.sendMessage((ICommandSender)MinecraftServer.func_71276_C(), receiverMessage);
                OutputHandler.sendMessage((ICommandSender)sender, senderMessage);
            } else if (target.toLowerCase().startsWith("irc")) {
                target = target.substring(3);
                String senderMessage = EnumChatFormatting.GOLD + "(IRC)[me -> " + target + "] " + EnumChatFormatting.GRAY;
                String receiverMessage = new String();
                for (int i = 0; i < args.length; ++i) {
                    receiverMessage = receiverMessage + args[i];
                    senderMessage = senderMessage + args[i];
                    if (i == args.length - 1) continue;
                    receiverMessage = receiverMessage + " ";
                    senderMessage = senderMessage + " ";
                }
                try {
                    IRCHelper.privateMessage(sender.func_70005_c_(), target, receiverMessage);
                    OutputHandler.sendMessage((ICommandSender)sender, senderMessage);
                }
                catch (Exception e) {
                    OutputHandler.chatError((ICommandSender)sender, "Unable to send message to: " + target);
                }
            } else {
                EntityPlayerMP receiver = MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(target);
                if (receiver == null) {
                    OutputHandler.chatError((ICommandSender)sender, target + " is not a valid username");
                    return;
                }
                String senderMessage = EnumChatFormatting.GOLD + "[ me -> " + EnumChatFormatting.GRAY + receiver.func_70005_c_() + EnumChatFormatting.GOLD + "] " + EnumChatFormatting.GRAY;
                String receiverMessage = EnumChatFormatting.GOLD + "[" + EnumChatFormatting.GRAY + sender.func_70005_c_() + EnumChatFormatting.GOLD + " -> me ] " + EnumChatFormatting.GRAY;
                for (int i = 0; i < args.length; ++i) {
                    receiverMessage = receiverMessage + args[i];
                    senderMessage = senderMessage + args[i];
                    if (i == args.length - 1) continue;
                    receiverMessage = receiverMessage + " ";
                    senderMessage = senderMessage + " ";
                }
                OutputHandler.sendMessage((ICommandSender)sender, senderMessage);
                OutputHandler.sendMessage((ICommandSender)receiver, receiverMessage);
            }
        }
    }

    @Override
    public void processCommandConsole(ICommandSender sender, String[] args) {
        if (args.length == 0) {
            OutputHandler.chatError(sender, "Improper syntax. Please try this instead: /msg <player> <message>");
            return;
        }
        if (args.length > 0) {
            String target = CommandMsg.getPlayerReply("server");
            if (target == null) {
                OutputHandler.chatError(sender, "You have no previous recorded message recipient.");
                return;
            }
            EntityPlayerMP receiver = UserIdent.getPlayerByMatchOrUsername(sender, args[0]);
            if (receiver == null) {
                OutputHandler.chatError(sender, target + " is not a valid username");
                return;
            }
            String senderMessage = "[ me -> " + receiver.func_70005_c_() + "] ";
            String receiverMessage = EnumChatFormatting.GOLD + "[" + EnumChatFormatting.DARK_PURPLE + "Server" + EnumChatFormatting.GOLD + " -> me ] " + EnumChatFormatting.GRAY;
            for (int i = 0; i < args.length; ++i) {
                receiverMessage = receiverMessage + args[i];
                senderMessage = senderMessage + args[i];
                if (i == args.length - 1) continue;
                receiverMessage = receiverMessage + " ";
                senderMessage = senderMessage + " ";
            }
            OutputHandler.sendMessage(sender, senderMessage);
            OutputHandler.sendMessage((ICommandSender)receiver, receiverMessage);
        }
    }

    @Override
    public boolean canConsoleUseCommand() {
        return true;
    }

    @Override
    public String getPermissionNode() {
        return "fe.chat." + this.func_71517_b();
    }

    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        return null;
    }

    public String func_71518_a(ICommandSender sender) {
        return "/r <message>";
    }

    @Override
    public PermissionsManager.RegisteredPermValue getDefaultPermission() {
        return PermissionsManager.RegisteredPermValue.TRUE;
    }
}

