/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.chat.commands;

import com.forgeessentials.chat.commands.CommandMsg;
import com.forgeessentials.core.commands.ForgeEssentialsCommandBase;
import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.util.UserIdent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.permissions.PermissionsManager;

public class CommandPm
extends ForgeEssentialsCommandBase {
    private static Map<String, String> persistentMessage;
    private List<String> aliasList;

    public CommandPm() {
        persistentMessage = new HashMap<String, String>();
        this.aliasList = new LinkedList<String>();
        this.aliasList.add("persistentmessage");
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public static boolean isMessagePersistent(String username) {
        return persistentMessage.containsKey(username);
    }

    public static void processChat(ICommandSender sender, String[] args) {
        if (sender instanceof EntityPlayer) {
            String target = persistentMessage.get(sender.func_70005_c_());
            if (target.equalsIgnoreCase("server") || target.equalsIgnoreCase("console")) {
                CommandMsg.clearReply("server");
                CommandMsg.addReply("server", sender.func_70005_c_());
                String senderMessage = EnumChatFormatting.GOLD + "[ me -> " + EnumChatFormatting.DARK_PURPLE + "Server" + EnumChatFormatting.GOLD + "] " + EnumChatFormatting.GRAY;
                String receiverMessage = EnumChatFormatting.GOLD + "[" + EnumChatFormatting.DARK_PURPLE + "Server" + EnumChatFormatting.GOLD + " -> me ] ";
                for (int i = 0; i < args.length; ++i) {
                    receiverMessage = receiverMessage + args[i];
                    senderMessage = senderMessage + args[i];
                    if (i == args.length - 1) continue;
                    receiverMessage = receiverMessage + " ";
                    senderMessage = senderMessage + " ";
                }
                OutputHandler.sendMessage((ICommandSender)MinecraftServer.func_71276_C(), receiverMessage);
                OutputHandler.sendMessage(sender, senderMessage);
            } else {
                EntityPlayerMP receiver = UserIdent.getPlayerByMatchOrUsername(sender, args[0]);
                if (receiver == null) {
                    OutputHandler.chatError(sender, String.format("Player %s does not exist, or is not online.", args[0]));
                    return;
                }
                CommandMsg.clearReply(receiver.func_70005_c_());
                CommandMsg.addReply(receiver.func_70005_c_(), sender.func_70005_c_());
                String senderMessage = EnumChatFormatting.GOLD + "[ me -> " + EnumChatFormatting.GRAY + receiver.func_70005_c_() + EnumChatFormatting.GOLD + "] " + EnumChatFormatting.WHITE;
                String receiverMessage = EnumChatFormatting.GOLD + "[" + EnumChatFormatting.GRAY + sender.func_70005_c_() + EnumChatFormatting.GOLD + " -> me ] " + EnumChatFormatting.WHITE;
                for (int i = 1; i < args.length; ++i) {
                    receiverMessage = receiverMessage + args[i];
                    senderMessage = senderMessage + args[i];
                    if (i == args.length - 1) continue;
                    receiverMessage = receiverMessage + " ";
                    senderMessage = senderMessage + " ";
                }
                OutputHandler.sendMessage(sender, senderMessage);
                OutputHandler.sendMessage((ICommandSender)receiver, receiverMessage);
            }
        }
    }

    public String func_71517_b() {
        return "pm";
    }

    public List<String> func_71514_a() {
        return this.aliasList;
    }

    @Override
    public void processCommandPlayer(EntityPlayerMP sender, String[] args) {
        if (args.length == 0) {
            if (persistentMessage.containsKey(sender.func_70005_c_())) {
                persistentMessage.remove(sender.func_70005_c_());
                OutputHandler.chatConfirmation((ICommandSender)sender, "Persistent message has been disabled.");
            } else {
                OutputHandler.chatWarning((ICommandSender)sender, "Persistent message is already disabled.");
            }
            return;
        }
        if (args.length > 0) {
            if (args[0].equalsIgnoreCase("help")) {
                OutputHandler.chatNotification((ICommandSender)sender, "Use /pm <player> to engage persistent message. /pm to return to normal chat.");
            } else {
                EntityPlayerMP target = UserIdent.getPlayerByMatchOrUsername((ICommandSender)sender, args[0]);
                if (target == null) {
                    OutputHandler.chatError((ICommandSender)sender, String.format("Player %s does not exist, or is not online.", args[0]));
                    return;
                }
                if (persistentMessage.containsKey(sender.func_70005_c_())) {
                    persistentMessage.remove(sender.func_70005_c_());
                }
                persistentMessage.put(sender.func_70005_c_(), target.func_70005_c_());
                OutputHandler.chatConfirmation((ICommandSender)sender, String.format("Persistent message to %s enabled.", target.func_70005_c_()));
            }
            return;
        }
        if (args.length > 1) {
            String[] args2 = new String[args.length - 1];
            for (int i = 1; i < args.length; ++i) {
                args2[i - 1] = args[i];
            }
            CommandPm.processChat((ICommandSender)sender, args2);
        }
    }

    @Override
    public void processCommandConsole(ICommandSender sender, String[] args) {
        if (args.length == 0) {
            if (persistentMessage.containsKey(sender.func_70005_c_())) {
                persistentMessage.remove(sender.func_70005_c_());
                OutputHandler.chatConfirmation(sender, "Persistent message has been disabled.");
            } else {
                OutputHandler.chatWarning(sender, "Persistent message is already disabled.");
            }
            return;
        }
        if (args.length > 0) {
            if (args[0].equalsIgnoreCase("help")) {
                OutputHandler.chatNotification(sender, "Use /pm <player> to engage persistent message. /pm to return to normal chat.");
            } else {
                EntityPlayerMP target = UserIdent.getPlayerByMatchOrUsername(sender, args[0]);
                if (target == null) {
                    OutputHandler.chatError(sender, String.format("Player %s does not exist, or is not online.", args[0]));
                    return;
                }
                if (persistentMessage.containsKey(sender.func_70005_c_())) {
                    persistentMessage.remove(sender.func_70005_c_());
                }
                persistentMessage.put(sender.func_70005_c_(), target.func_70005_c_());
                OutputHandler.chatConfirmation(sender, String.format("Persistent message to %s enabled.", target.func_70005_c_()));
            }
            return;
        }
        if (args.length > 1) {
            EntityPlayerMP receiver = UserIdent.getPlayerByMatchOrUsername(sender, args[0]);
            if (receiver == null) {
                OutputHandler.chatError(sender, String.format("Player %s does not exist, or is not online.", args[0]));
                return;
            }
            CommandMsg.clearReply(receiver.func_70005_c_());
            CommandMsg.addReply(receiver.func_70005_c_(), "server");
            if (persistentMessage.containsKey("server")) {
                persistentMessage.remove("server");
            }
            persistentMessage.put(sender.func_70005_c_(), receiver.func_70005_c_());
            OutputHandler.chatConfirmation(sender, "Persistent message to " + receiver.func_70005_c_() + " enabled.");
            String senderMessage = "[ me -> " + receiver.func_70005_c_() + "] ";
            String receiverMessage = EnumChatFormatting.GOLD + "[" + EnumChatFormatting.DARK_PURPLE + "Server" + EnumChatFormatting.GOLD + " -> me ] " + EnumChatFormatting.GRAY;
            for (int i = 1; i < args.length; ++i) {
                receiverMessage = receiverMessage + args[i];
                senderMessage = senderMessage + args[i];
                if (i == args.length - 1) continue;
                receiverMessage = receiverMessage + " ";
                senderMessage = senderMessage + " ";
            }
            OutputHandler.sendMessage(sender, senderMessage);
            OutputHandler.sendMessage((ICommandSender)receiver, receiverMessage);
        }
    }

    @Override
    public boolean canConsoleUseCommand() {
        return false;
    }

    @Override
    public String getPermissionNode() {
        return "fe.chat." + this.func_71517_b();
    }

    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        return null;
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent e) {
        persistentMessage.remove(e.player.getPersistentID());
    }

    public String func_71518_a(ICommandSender sender) {
        return "/pm <player> Enable persistent message for a player. Use /pm to turn off.";
    }

    @Override
    public PermissionsManager.RegisteredPermValue getDefaultPermission() {
        return PermissionsManager.RegisteredPermValue.TRUE;
    }
}

