/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.chat.commands;

import com.forgeessentials.core.commands.ForgeEssentialsCommandBase;
import com.forgeessentials.util.OutputHandler;
import java.util.Arrays;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.permissions.PermissionsManager;

public class CommandNickname
extends ForgeEssentialsCommandBase {
    public String func_71517_b() {
        return "nickname";
    }

    public List<String> func_71514_a() {
        return Arrays.asList("nick");
    }

    @Override
    public void processCommandPlayer(EntityPlayerMP sender, String[] args) {
        if (args.length == 1) {
            if (args[0].equalsIgnoreCase("del")) {
                NBTTagCompound tag = sender.getEntityData().func_74775_l("PlayerPersisted");
                tag.func_82580_o("nickname");
                sender.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)tag);
                OutputHandler.chatConfirmation((ICommandSender)sender, "Nickname removed.");
            } else {
                NBTTagCompound tag = sender.getEntityData().func_74775_l("PlayerPersisted");
                tag.func_74778_a("nickname", args[0]);
                sender.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)tag);
                OutputHandler.chatConfirmation((ICommandSender)sender, "Nickname set to " + args[0]);
            }
        } else if (args.length == 2) {
            if (PermissionsManager.checkPermission((EntityPlayer)sender, this.getPermissionNode() + ".others")) {
                EntityPlayerMP player = CommandNickname.func_82359_c((ICommandSender)sender, (String)args[0]);
                if (args[1].equalsIgnoreCase("del")) {
                    player.getEntityData().func_74775_l("PlayerPersisted").func_82580_o("nickname");
                    OutputHandler.chatConfirmation((ICommandSender)sender, "Nickname of player " + args[0] + " removed");
                } else {
                    player.getEntityData().func_74775_l("PlayerPersisted").func_74778_a("nickname", args[1]);
                    OutputHandler.chatConfirmation((ICommandSender)sender, "Nickname of player " + args[0] + " set to " + args[1]);
                }
            } else {
                OutputHandler.chatError((ICommandSender)sender, "You don't have permissions for that.");
            }
        } else {
            OutputHandler.chatError((ICommandSender)sender, "Improper syntax. Please try this instead: <username> [nickname|del]");
        }
    }

    @Override
    public void func_71515_b(ICommandSender sender, String[] args) {
        if (sender instanceof EntityPlayerMP) {
            this.processCommandPlayer((EntityPlayerMP)sender, args);
        }
        if (args.length >= 1) {
            EntityPlayerMP player = CommandNickname.func_82359_c((ICommandSender)sender, (String)args[0]);
            if (args.length == 2) {
                player.getEntityData().func_74775_l("PlayerPersisted").func_74778_a("nickname", args[1]);
                OutputHandler.chatConfirmation(sender, "Nickname of player " + player.func_70005_c_() + " set to " + args[1]);
            } else if (args.length == 1) {
                player.getEntityData().func_74775_l("PlayerPersisted").func_82580_o("nickname");
                OutputHandler.chatConfirmation(sender, "Nickname of player " + player.func_70005_c_() + " removed");
            } else {
                OutputHandler.chatError(sender, "Improper syntax. Please try this instead: <username> [nickname|del]");
            }
        } else {
            OutputHandler.chatError(sender, "Improper syntax. Please try this instead: <username> [nickname|del]");
        }
    }

    @Override
    public boolean canConsoleUseCommand() {
        return true;
    }

    @Override
    public String getPermissionNode() {
        return "fe.chat." + this.func_71517_b();
    }

    public String func_71518_a(ICommandSender sender) {
        return "/nick <username> [nickname|del> Edit a player's nickname.";
    }

    @Override
    public PermissionsManager.RegisteredPermValue getDefaultPermission() {
        return PermissionsManager.RegisteredPermValue.TRUE;
    }
}

