/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.chat.commands;

import com.forgeessentials.chat.ModuleChat;
import com.forgeessentials.chat.irc.IRCHelper;
import com.forgeessentials.core.commands.ForgeEssentialsCommandBase;
import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.util.UserIdent;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.permissions.PermissionsManager;

public class CommandMsg
extends ForgeEssentialsCommandBase {
    private static Map<String, String> playerReply;
    private List<String> aliasList;

    public CommandMsg() {
        playerReply = new HashMap<String, String>();
        this.aliasList = new LinkedList<String>();
        this.aliasList.add("tell");
        this.aliasList.add("whisper");
    }

    public static String getPlayerReply(String player) {
        return playerReply.get(player);
    }

    public static void clearReply(String player) {
        if (playerReply.containsKey(player)) {
            playerReply.remove(player);
        }
    }

    public static void addReply(String player, String target) {
        playerReply.put(player, target);
    }

    public String func_71517_b() {
        return "msg";
    }

    public List<String> func_71514_a() {
        return this.aliasList;
    }

    @Override
    public void processCommandPlayer(EntityPlayerMP sender, String[] args) {
        if (args.length > 1) {
            int i;
            String receiverMessage;
            String senderMessage;
            if (args[0].equalsIgnoreCase("server") || args[0].equalsIgnoreCase("console")) {
                CommandMsg.clearReply(sender.func_70005_c_());
                CommandMsg.clearReply("server");
                CommandMsg.addReply(sender.func_70005_c_(), "server");
                CommandMsg.addReply("server", sender.func_70005_c_());
                senderMessage = EnumChatFormatting.GOLD + "[ me -> " + EnumChatFormatting.DARK_PURPLE + "Server" + EnumChatFormatting.GOLD + "] " + EnumChatFormatting.GRAY;
                receiverMessage = EnumChatFormatting.GOLD + "[" + EnumChatFormatting.DARK_PURPLE + "Server" + EnumChatFormatting.GOLD + " -> me ] ";
                for (i = 0; i < args.length; ++i) {
                    receiverMessage = receiverMessage + args[i];
                    senderMessage = senderMessage + args[i];
                    if (i == args.length - 1) continue;
                    receiverMessage = receiverMessage + " ";
                    senderMessage = senderMessage + " ";
                }
                OutputHandler.sendMessage((ICommandSender)MinecraftServer.func_71276_C(), receiverMessage);
                OutputHandler.sendMessage((ICommandSender)sender, senderMessage);
            }
            if (ModuleChat.connectToIRC && args[0].equalsIgnoreCase("irc")) {
                CommandMsg.clearReply(sender.func_70005_c_());
                CommandMsg.clearReply("irc" + args[1].toLowerCase());
                CommandMsg.addReply(sender.func_70005_c_(), "irc" + args[1].toLowerCase());
                CommandMsg.addReply("irc" + args[1].toLowerCase(), sender.func_70005_c_());
                senderMessage = EnumChatFormatting.GOLD + "(IRC)[me -> " + args[1] + "] " + EnumChatFormatting.GRAY;
                receiverMessage = new String();
                for (i = 2; i < args.length; ++i) {
                    receiverMessage = receiverMessage + args[i];
                    senderMessage = senderMessage + args[i];
                    if (i == args.length - 1) continue;
                    receiverMessage = receiverMessage + " ";
                    senderMessage = senderMessage + " ";
                }
                try {
                    IRCHelper.privateMessage(sender.func_70005_c_(), args[1], receiverMessage);
                    OutputHandler.sendMessage((ICommandSender)sender, senderMessage);
                }
                catch (Exception e) {
                    OutputHandler.sendMessage((ICommandSender)sender, "Unable to send message to: " + args[1]);
                }
            } else {
                EntityPlayerMP receiver = UserIdent.getPlayerByMatchOrUsername((ICommandSender)sender, args[0]);
                if (receiver == null) {
                    OutputHandler.chatError((ICommandSender)sender, String.format("Player %s does not exist, or is not online.", args[0]));
                    return;
                }
                CommandMsg.clearReply(sender.func_70005_c_());
                CommandMsg.clearReply(receiver.func_70005_c_());
                CommandMsg.addReply(sender.func_70005_c_(), receiver.func_70005_c_());
                CommandMsg.addReply(receiver.func_70005_c_(), sender.func_70005_c_());
                String senderMessage2 = EnumChatFormatting.GOLD + "[ me -> " + EnumChatFormatting.GRAY + receiver.func_70005_c_() + EnumChatFormatting.GOLD + "] " + EnumChatFormatting.WHITE;
                String receiverMessage2 = EnumChatFormatting.GOLD + "[" + EnumChatFormatting.GRAY + sender.func_70005_c_() + EnumChatFormatting.GOLD + " -> me ] " + EnumChatFormatting.WHITE;
                for (int i2 = 1; i2 < args.length; ++i2) {
                    receiverMessage2 = receiverMessage2 + args[i2];
                    senderMessage2 = senderMessage2 + args[i2];
                    if (i2 == args.length - 1) continue;
                    receiverMessage2 = receiverMessage2 + " ";
                    senderMessage2 = senderMessage2 + " ";
                }
                OutputHandler.sendMessage((ICommandSender)sender, senderMessage2);
                OutputHandler.sendMessage((ICommandSender)receiver, receiverMessage2);
            }
        }
    }

    @Override
    public void processCommandConsole(ICommandSender sender, String[] args) {
        if (args.length > 1) {
            EntityPlayerMP receiver = UserIdent.getPlayerByMatchOrUsername(sender, args[0]);
            if (receiver == null) {
                OutputHandler.chatError(sender, String.format("Player %s does not exist, or is not online.", args[0]));
                return;
            }
            CommandMsg.clearReply(receiver.func_70005_c_());
            CommandMsg.clearReply("server");
            CommandMsg.addReply(receiver.func_70005_c_(), "server");
            CommandMsg.addReply("server", receiver.func_70005_c_());
            String senderMessage = "[ me -> " + receiver.func_70005_c_() + "] ";
            String receiverMessage = EnumChatFormatting.GOLD + "[" + EnumChatFormatting.DARK_PURPLE + "Server" + EnumChatFormatting.GOLD + " -> me ] " + EnumChatFormatting.GRAY;
            for (int i = 1; i < args.length; ++i) {
                receiverMessage = receiverMessage + args[i];
                senderMessage = senderMessage + args[i];
                if (i == args.length - 1) continue;
                receiverMessage = receiverMessage + " ";
                senderMessage = senderMessage + " ";
            }
            OutputHandler.sendMessage(sender, senderMessage);
            OutputHandler.sendMessage((ICommandSender)receiver, receiverMessage);
        }
    }

    @Override
    public boolean canConsoleUseCommand() {
        return true;
    }

    @Override
    public String getPermissionNode() {
        return "fe.chat." + this.func_71517_b();
    }

    public String func_71518_a(ICommandSender sender) {
        return "/msg <irc> <player> <message> Send a message to another player, who is either logged on to the server or online in IRC.";
    }

    @Override
    public PermissionsManager.RegisteredPermValue getDefaultPermission() {
        return PermissionsManager.RegisteredPermValue.TRUE;
    }
}

