/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.chat.commands;

import com.forgeessentials.chat.ChatFormatter;
import com.forgeessentials.core.ForgeEssentials;
import com.forgeessentials.core.commands.ForgeEssentialsCommandBase;
import com.forgeessentials.util.OutputHandler;
import com.google.common.base.Preconditions;
import net.minecraft.command.ICommandSender;
import net.minecraftforge.permissions.PermissionsManager;

public class CommandBannedWords
extends ForgeEssentialsCommandBase {
    @Override
    public void func_71515_b(ICommandSender sender, String[] args) {
        if (args.length == 0 || args.length == 1 && args[0].equals("list")) {
            OutputHandler.chatNotification(sender, "List of banned words");
            String out = "";
            boolean firstEntry = true;
            for (String banned : ChatFormatter.bannedWords) {
                out = out + (firstEntry ? banned : ", " + banned);
                firstEntry = false;
            }
            OutputHandler.chatNotification(sender, out);
        }
        if (args.length > 2) {
            switch (args[0]) {
                case "add": {
                    try {
                        ChatFormatter.bannedWords.add((String)Preconditions.checkNotNull((Object)args[1]));
                        ForgeEssentials.getConfigManager().save("Chat");
                        OutputHandler.chatNotification(sender, String.format("Added word %s to banned list", args[1]));
                    }
                    catch (NullPointerException e) {
                        OutputHandler.chatError(sender, "You need to specify a word to ban!");
                    }
                    break;
                }
                case "remove": {
                    try {
                        ChatFormatter.bannedWords.remove(Preconditions.checkNotNull((Object)args[1]));
                        ForgeEssentials.getConfigManager().save("Chat");
                        OutputHandler.chatNotification(sender, String.format("Removed word %s from banned list", args[1]));
                        break;
                    }
                    catch (NullPointerException e) {
                        OutputHandler.chatError(sender, "You need to specify a word to unban!");
                    }
                }
            }
        }
    }

    @Override
    public boolean canConsoleUseCommand() {
        return true;
    }

    @Override
    public String getPermissionNode() {
        return "fe.chat.bannedwords.admin";
    }

    @Override
    public PermissionsManager.RegisteredPermValue getDefaultPermission() {
        return PermissionsManager.RegisteredPermValue.OP;
    }

    public String func_71517_b() {
        return "bannedwords";
    }

    public String func_71518_a(ICommandSender p_71518_1_) {
        return "/bannedwords [list|add|remove] <word> List, add or remove banned words.";
    }
}

