/*
 * Decompiled with CFR 0.152.
 */
package com.forgeessentials.chat;

import com.forgeessentials.api.APIRegistry;
import com.forgeessentials.chat.AutoMessage;
import com.forgeessentials.chat.ChatFormatter;
import com.forgeessentials.chat.CommandMuter;
import com.forgeessentials.chat.ConfigChat;
import com.forgeessentials.chat.MailSystem;
import com.forgeessentials.chat.commands.CommandAutoMessage;
import com.forgeessentials.chat.commands.CommandBannedWords;
import com.forgeessentials.chat.commands.CommandIRC;
import com.forgeessentials.chat.commands.CommandMail;
import com.forgeessentials.chat.commands.CommandMsg;
import com.forgeessentials.chat.commands.CommandMute;
import com.forgeessentials.chat.commands.CommandNickname;
import com.forgeessentials.chat.commands.CommandPm;
import com.forgeessentials.chat.commands.CommandR;
import com.forgeessentials.chat.commands.CommandUnmute;
import com.forgeessentials.chat.irc.IRCChatFormatter;
import com.forgeessentials.chat.irc.IRCHelper;
import com.forgeessentials.chat.irc.PlayerEventHandler;
import com.forgeessentials.core.ForgeEssentials;
import com.forgeessentials.core.environment.CommandSetChecker;
import com.forgeessentials.core.moduleLauncher.FEModule;
import com.forgeessentials.util.FunctionHelper;
import com.forgeessentials.util.OutputHandler;
import com.forgeessentials.util.events.FEModuleEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.io.File;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Set;
import net.minecraft.command.CommandHandler;
import net.minecraft.command.ICommand;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.permissions.PermissionsManager;

@FEModule(name="Chat", parentMod=ForgeEssentials.class)
public class ModuleChat {
    public static final String CONFIG_CATEGORY = "Chat";
    @FEModule.ModuleDir
    public static File moduleDir;
    public static PrintWriter chatLog;
    public static PrintWriter cmdLog;
    public static File logdir;
    public static boolean connectToIRC;
    private MailSystem mailsystem;
    private PlayerEventHandler ircPlayerHandler;
    private AutoMessage autoMessage;

    @SubscribeEvent
    public void load(FEModuleEvent.FEModuleInitEvent e) {
        ForgeEssentials.getConfigManager().registerLoader(CONFIG_CATEGORY, new ConfigChat());
        MinecraftForge.EVENT_BUS.register((Object)new ChatFormatter());
        MinecraftForge.EVENT_BUS.register((Object)new CommandMuter());
        if (!IRCHelper.suppressEvents && connectToIRC) {
            this.ircPlayerHandler = new PlayerEventHandler();
            MinecraftForge.EVENT_BUS.register((Object)this.ircPlayerHandler);
            FMLCommonHandler.instance().bus().register((Object)this.ircPlayerHandler);
            MinecraftForge.EVENT_BUS.register((Object)new IRCChatFormatter());
        }
    }

    @SubscribeEvent
    public void postLoad(FEModuleEvent.FEModulePostInitEvent e) {
        this.mailsystem = new MailSystem();
    }

    @SubscribeEvent
    public void serverStarting(FEModuleEvent.FEModuleServerInitEvent e) {
        File file;
        FunctionHelper.registerServerCommand(new CommandMsg());
        FunctionHelper.registerServerCommand(new CommandR());
        FunctionHelper.registerServerCommand(new CommandNickname());
        FunctionHelper.registerServerCommand(new CommandPm());
        FunctionHelper.registerServerCommand(new CommandMute());
        FunctionHelper.registerServerCommand(new CommandUnmute());
        FunctionHelper.registerServerCommand(new CommandMail());
        FunctionHelper.registerServerCommand(new CommandAutoMessage());
        FunctionHelper.registerServerCommand(new CommandIRC());
        new CommandBannedWords().register();
        try {
            logdir = moduleDir;
            logdir.mkdirs();
        }
        catch (Exception e1) {
            OutputHandler.felog.warning("Could not create chat log directory!");
        }
        try {
            file = new File(logdir, "chat-" + FunctionHelper.getCurrentDateString() + ".log");
            if (!file.exists()) {
                file.createNewFile();
            }
            chatLog = new PrintWriter(file);
        }
        catch (Exception e1) {
            OutputHandler.felog.warning("Could not create chat log file!");
        }
        try {
            file = new File(logdir, "cmd-" + FunctionHelper.getCurrentDateString() + ".log");
            if (!file.exists()) {
                file.createNewFile();
            }
            cmdLog = new PrintWriter(file);
        }
        catch (Exception e1) {
            OutputHandler.felog.warning("Could not create command log file!");
        }
        APIRegistry.perms.registerPermission("fe.chat.usecolor", PermissionsManager.RegisteredPermValue.TRUE);
        APIRegistry.perms.registerPermission("fe.chat.nickname.others", PermissionsManager.RegisteredPermValue.OP);
    }

    @SubscribeEvent
    public void serverStarted(FEModuleEvent.FEModuleServerPostInitEvent e) {
        ModuleChat.removeTell(FMLCommonHandler.instance().getMinecraftServerInstance());
        this.autoMessage = new AutoMessage(FMLCommonHandler.instance().getMinecraftServerInstance());
        MailSystem.LoadAll();
        FMLCommonHandler.instance().bus().register((Object)this.mailsystem);
        if (connectToIRC) {
            IRCHelper.connectToServer();
        }
    }

    @SubscribeEvent
    public void serverStopping(FEModuleEvent.FEModuleServerStopEvent e) {
        MailSystem.SaveAll();
        chatLog.close();
        cmdLog.close();
        if (connectToIRC) {
            IRCHelper.shutdown();
        }
    }

    private static void removeTell(MinecraftServer server) {
        if (server.func_71187_D() instanceof CommandHandler) {
            try {
                Set cmdList = (Set)ReflectionHelper.getPrivateValue(CommandHandler.class, (Object)((CommandHandler)server.func_71187_D()), (String[])CommandSetChecker.FIELDNAME);
                ICommand toRemove = null;
                Class<?> cmdClass = null;
                for (Object cmdObj : cmdList) {
                    ICommand cmd = (ICommand)cmdObj;
                    if (!cmd.func_71517_b().equalsIgnoreCase("tell")) continue;
                    try {
                        cmdClass = cmd.getClass();
                        Package pkg = cmdClass.getPackage();
                        if (pkg != null && pkg.getName().contains("ForgeEssentials")) continue;
                        toRemove = cmd;
                        break;
                    }
                    catch (Exception e) {
                        OutputHandler.felog.finer("Can't remove " + cmd.func_71517_b());
                        OutputHandler.felog.finer("" + e.getLocalizedMessage());
                        e.printStackTrace();
                    }
                }
                if (cmdClass != null && toRemove != null) {
                    OutputHandler.felog.finer("Removing command '" + toRemove.func_71517_b() + "' from class: " + cmdClass.getName());
                    cmdList.remove(toRemove);
                }
                ReflectionHelper.setPrivateValue(CommandHandler.class, (Object)((CommandHandler)server.func_71187_D()), (Object)cmdList, (String[])new String[]{"commandSet", "b", "field_71561_b"});
                Map cmds = (Map)ReflectionHelper.getPrivateValue(CommandHandler.class, (Object)((CommandHandler)server.func_71187_D()), (String[])new String[]{"commandMap", "a", "field_71562_a"});
                if (cmds.containsKey("tell")) {
                    OutputHandler.felog.finer("Removing command tell from vanilla set.");
                    cmds.remove("tell");
                    cmds.put("tell", new CommandMsg());
                }
                ReflectionHelper.setPrivateValue(CommandHandler.class, (Object)((CommandHandler)server.func_71187_D()), (Object)cmds, (String[])new String[]{"commandMap", "a", "field_71562_a"});
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

